/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.address;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.resolver.AddressResolver;
import io.netty5.resolver.AddressResolverGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.Objects;

public class ResolveAddressHandler
implements ChannelHandler {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = Objects.requireNonNull(resolverGroup, "resolverGroup");
    }

    public boolean isSharable() {
        return true;
    }

    public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        AddressResolver resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            Promise promise = ctx.newPromise();
            resolver.resolve(remoteAddress).addListener(future -> {
                Throwable cause = future.cause();
                if (cause != null) {
                    promise.setFailure(cause);
                } else {
                    ctx.connect((SocketAddress)future.getNow(), localAddress).cascadeTo(promise);
                }
                ctx.pipeline().remove((ChannelHandler)this);
            });
            return promise.asFuture();
        }
        Future f = ctx.connect(remoteAddress, localAddress);
        ctx.pipeline().remove((ChannelHandler)this);
        return f;
    }
}

