/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal;

import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.FastThreadLocal;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public final class ThreadExecutorMap {
    private static final FastThreadLocal<EventExecutor> mappings = new FastThreadLocal();

    private ThreadExecutorMap() {
    }

    public static EventExecutor currentExecutor() {
        return mappings.get();
    }

    private static void setCurrentEventExecutor(EventExecutor executor) {
        mappings.set(executor);
    }

    public static Executor apply(Executor executor, EventExecutor eventExecutor) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(eventExecutor, "eventExecutor");
        return command -> executor.execute(ThreadExecutorMap.apply(command, eventExecutor));
    }

    public static Runnable apply(Runnable command, EventExecutor eventExecutor) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(eventExecutor, "eventExecutor");
        return () -> {
            ThreadExecutorMap.setCurrentEventExecutor(eventExecutor);
            try {
                command.run();
            }
            finally {
                ThreadExecutorMap.setCurrentEventExecutor(null);
            }
        };
    }

    public static ThreadFactory apply(ThreadFactory threadFactory, EventExecutor eventExecutor) {
        Objects.requireNonNull(threadFactory, "command");
        Objects.requireNonNull(eventExecutor, "eventExecutor");
        return r -> threadFactory.newThread(ThreadExecutorMap.apply(r, eventExecutor));
    }
}

