/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import java.util.Objects;

public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final FutureListener<Object> listener = new FutureListener<Object>(){

        @Override
        public void operationComplete(Future<?> future) {
            if (PromiseCombiner.this.executor.inEventLoop()) {
                this.operationComplete0(future);
            } else {
                PromiseCombiner.this.executor.execute(() -> this.operationComplete0(future));
            }
        }

        private void operationComplete0(Future<?> future) {
            assert (PromiseCombiner.this.executor.inEventLoop());
            ++PromiseCombiner.this.doneCount;
            if (future.isFailed() && PromiseCombiner.this.cause == null) {
                PromiseCombiner.this.cause = future.cause();
            }
            if (PromiseCombiner.this.doneCount == PromiseCombiner.this.expectedCount && PromiseCombiner.this.aggregatePromise != null) {
                PromiseCombiner.this.tryPromise();
            }
        }
    };
    private final EventExecutor executor;

    public PromiseCombiner(EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public void add(Future<?> future) {
        this.checkAddAllowed();
        this.checkInEventLoop();
        ++this.expectedCount;
        future.addListener(this.listener);
    }

    public void addAll(Future<?> ... futures) {
        for (Future<?> future : futures) {
            this.add(future);
        }
    }

    public void finish(Promise<Void> aggregatePromise) {
        Objects.requireNonNull(aggregatePromise, "aggregatePromise");
        this.checkInEventLoop();
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Already finished");
        }
        this.aggregatePromise = aggregatePromise;
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private void checkInEventLoop() {
        if (!this.executor.inEventLoop()) {
            throw new IllegalStateException("Must be called from EventExecutor thread");
        }
    }

    private boolean tryPromise() {
        return this.cause == null ? this.aggregatePromise.trySuccess(null) : this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }
}

