/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.AbstractEventExecutor;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.EventExecutorGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.OrderedEventExecutor;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.UnstableApi;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@UnstableApi
public final class NonStickyEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutorGroup group;
    private final int maxTaskExecutePerRun;

    public NonStickyEventExecutorGroup(EventExecutorGroup group) {
        this(group, 1024);
    }

    public NonStickyEventExecutorGroup(EventExecutorGroup group, int maxTaskExecutePerRun) {
        this.group = NonStickyEventExecutorGroup.verify(group);
        this.maxTaskExecutePerRun = ObjectUtil.checkPositive(maxTaskExecutePerRun, "maxTaskExecutePerRun");
    }

    private static EventExecutorGroup verify(EventExecutorGroup group) {
        for (EventExecutor executor : Objects.requireNonNull(group, "group")) {
            if (!(executor instanceof OrderedEventExecutor)) continue;
            throw new IllegalArgumentException("EventExecutorGroup " + group + " contains OrderedEventExecutors: " + executor);
        }
        return group;
    }

    private NonStickyOrderedEventExecutor newExecutor(EventExecutor executor) {
        return new NonStickyOrderedEventExecutor(executor, this.maxTaskExecutePerRun);
    }

    @Override
    public boolean isShuttingDown() {
        return this.group.isShuttingDown();
    }

    @Override
    public Future<Void> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    @Override
    public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.group.shutdownGracefully(quietPeriod, timeout, unit);
    }

    @Override
    public Future<Void> terminationFuture() {
        return this.group.terminationFuture();
    }

    @Override
    public EventExecutor next() {
        return this.newExecutor(this.group.next());
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        final Iterator<EventExecutor> itr = this.group.iterator();
        return new Iterator<EventExecutor>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public EventExecutor next() {
                return NonStickyEventExecutorGroup.this.newExecutor((EventExecutor)itr.next());
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    @Override
    public Future<Void> submit(Runnable task) {
        return this.group.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.group.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.group.submit(task);
    }

    @Override
    public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.group.schedule(task, delay, unit);
    }

    @Override
    public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.group.schedule(task, delay, unit);
    }

    @Override
    public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.group.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Override
    public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.group.scheduleWithFixedDelay(task, initialDelay, delay, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.group.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.group.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.group.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable task) {
        this.group.execute(task);
    }

    private static final class NonStickyOrderedEventExecutor
    extends AbstractEventExecutor
    implements Runnable,
    OrderedEventExecutor {
        private final EventExecutor executor;
        private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
        private static final int NONE = 0;
        private static final int SUBMITTED = 1;
        private static final int RUNNING = 2;
        private final AtomicInteger state = new AtomicInteger();
        private final int maxTaskExecutePerRun;

        NonStickyOrderedEventExecutor(EventExecutor executor, int maxTaskExecutePerRun) {
            this.executor = executor;
            this.maxTaskExecutePerRun = maxTaskExecutePerRun;
        }

        @Override
        public void run() {
            if (!this.state.compareAndSet(1, 2)) {
                return;
            }
            block7: while (true) {
                int i = 0;
                try {
                    while (true) {
                        Runnable task;
                        if (i >= this.maxTaskExecutePerRun || (task = this.tasks.poll()) == null) continue block7;
                        NonStickyOrderedEventExecutor.safeExecute(task);
                        ++i;
                    }
                }
                finally {
                    if (i == this.maxTaskExecutePerRun) {
                        try {
                            this.state.set(1);
                            this.executor.execute(this);
                            return;
                        }
                        catch (Throwable ignore) {
                            this.state.set(2);
                        }
                    } else {
                        this.state.set(0);
                        if (!this.tasks.isEmpty() && this.state.compareAndSet(0, 2)) continue;
                        return;
                    }
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean inEventLoop(Thread thread) {
            return false;
        }

        @Override
        public boolean isShuttingDown() {
            return this.executor.isShutdown();
        }

        @Override
        public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            return this.executor.shutdownGracefully(quietPeriod, timeout, unit);
        }

        @Override
        public Future<Void> terminationFuture() {
            return this.executor.terminationFuture();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable task) {
            if (!this.tasks.offer(task)) {
                throw new RejectedExecutionException();
            }
            if (this.state.compareAndSet(0, 1)) {
                this.executor.execute(this);
            }
        }

        @Override
        public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }
}

