/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util;

import io.netty5.util.Resource;
import io.netty5.util.SafeCloseable;
import io.netty5.util.internal.SendFromSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Send<T extends Resource<T>>
extends SafeCloseable {
    public static <T extends Resource<T>> Send<T> sending(Class<T> concreteObjectType, Supplier<? extends T> supplier) {
        return new SendFromSupplier<T>(concreteObjectType, supplier);
    }

    public static boolean isSendOf(Class<?> type, Object candidate) {
        return candidate instanceof Send && ((Send)candidate).referentIsInstanceOf(type);
    }

    public T receive();

    default public <R extends Resource<R>> Send<R> map(Class<R> type, Function<T, R> mapper) {
        return Send.sending(type, () -> (Resource)mapper.apply(this.receive()));
    }

    @Override
    public void close();

    public boolean referentIsInstanceOf(Class<?> var1);
}

