/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.Recycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractPooledDerivedByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.Handle<AbstractPooledDerivedByteBuf<T>> recyclerHandle;
    private AbstractByteBuf buffer;

    AbstractPooledDerivedByteBuf(Recycler.Handle<? extends AbstractPooledDerivedByteBuf<T>> recyclerHandle) {
        super(0);
        this.recyclerHandle = recyclerHandle;
    }

    @Override
    public final AbstractByteBuf unwrap() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <U extends AbstractPooledDerivedByteBuf<T>> U init(AbstractByteBuf buffer, int readerIndex, int writerIndex, int maxCapacity) {
        buffer.retain();
        this.buffer = buffer;
        boolean success = false;
        try {
            this.maxCapacity(maxCapacity);
            this.setIndex(readerIndex, writerIndex);
            this.setRefCnt(1);
            AbstractPooledDerivedByteBuf castThis = this;
            success = true;
            AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = castThis;
            return (U)abstractPooledDerivedByteBuf;
        }
        finally {
            if (!success) {
                this.buffer = null;
                buffer.release();
            }
        }
    }

    @Override
    protected final void deallocate() {
        this.recyclerHandle.recycle(this);
        this.unwrap().release();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public final ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isReadOnly() {
        return this.unwrap().isReadOnly();
    }

    @Override
    public final boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public final int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int index, int length) {
        return this.nioBuffer(index, length);
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int index = this.readerIndex();
        return this.retainedSlice(index, this.writerIndex() - index);
    }

    @Override
    public final ByteBuf retainedSlice(int index, int length) {
        return PooledSlicedByteBuf.newInstance(this, index, length, index);
    }
}

