/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ServiceResponse
implements JsonSerializable {
    protected final String type;
    protected final String name;
    protected final String id;
    protected final String version;
    protected final Map<String, String> metadata;

    protected ServiceResponse(String type, String id, String name, String version, Map<String, String> metadata) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.version = version;
        this.metadata = metadata == null || metadata.isEmpty() ? null : metadata;
    }

    protected ServiceResponse(String type, ServiceResponse template) {
        this(type, template.id, template.name, template.version, template.metadata);
    }

    protected ServiceResponse(String type, JsonValue jv) {
        String jvType = JsonValueUtils.readString(jv, "type");
        if (Validator.emptyAsNull(jvType) == null) {
            throw new IllegalArgumentException("Type cannot be null or empty.");
        }
        if (!type.equals(jvType)) {
            throw new IllegalArgumentException("Invalid type for " + this.getClass().getSimpleName() + ". Expecting: " + type + ". Received " + jvType);
        }
        this.type = type;
        this.id = Validator.required(JsonValueUtils.readString(jv, "id"), "Id");
        this.name = Validator.required(JsonValueUtils.readString(jv, "name"), "Name");
        this.version = Validator.required(JsonValueUtils.readString(jv, "version"), "Version");
        this.metadata = JsonValueUtils.readStringStringMap(jv, "metadata");
    }

    protected static JsonValue parseMessage(byte[] bytes) {
        try {
            return JsonParser.parse(bytes);
        }
        catch (JsonParseException e) {
            return JsonValue.EMPTY_MAP;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getMetadata() {
        return this.metadata == null ? null : new HashMap<String, String>(this.metadata);
    }

    protected void subToJson(StringBuilder sb) {
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "id", this.id);
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "version", this.version);
        this.subToJson(sb);
        JsonUtils.addField(sb, "type", this.type);
        JsonUtils.addField(sb, "metadata", this.metadata);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceResponse that = (ServiceResponse)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return JsonUtils.mapEquals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }
}

