/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.utility;

public class RetryConfig {
    public static final int DEFAULT_ATTEMPTS = 2;
    public static final long[] DEFAULT_BACKOFF_POLICY = new long[]{250L, 250L, 500L, 500L, 3000L, 5000L};
    public static final RetryConfig DEFAULT_CONFIG = RetryConfig.builder().build();
    private final long[] backoffPolicy;
    private final int attempts;
    private final long deadline;

    private RetryConfig(Builder b) {
        this.backoffPolicy = b.backoffPolicy;
        this.attempts = b.attempts;
        this.deadline = b.deadline;
    }

    public long[] getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long[] backoffPolicy = DEFAULT_BACKOFF_POLICY;
        private int attempts = 2;
        private long deadline = Long.MAX_VALUE;

        public Builder backoffPolicy(long[] backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public Builder attempts(int attempts) {
            this.attempts = attempts < 1 ? 2 : attempts;
            return this;
        }

        public Builder deadline(long retryDeadlineMillis) {
            this.deadline = retryDeadlineMillis < 1L ? Long.MAX_VALUE : retryDeadlineMillis;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

