/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.utility;

import io.nats.client.JetStream;
import io.nats.client.Message;
import io.nats.client.PublishOptions;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.Headers;
import io.nats.client.utility.RetryAction;
import io.nats.client.utility.RetryConfig;
import io.nats.client.utility.RetryObserver;
import java.util.concurrent.CompletableFuture;

public class Retrier {
    private Retrier() {
    }

    public static <T> T execute(RetryConfig config, RetryAction<T> action) throws Exception {
        return Retrier.execute(config, action, e -> true);
    }

    public static <T> T execute(RetryConfig config, RetryAction<T> action, RetryObserver observer) throws Exception {
        long[] backoffPolicy = config.getBackoffPolicy();
        int plen = backoffPolicy.length;
        int retries = 0;
        long deadlineExpiresAt = System.currentTimeMillis() + config.getDeadline();
        if (deadlineExpiresAt < System.currentTimeMillis()) {
            deadlineExpiresAt = Long.MAX_VALUE;
        }
        while (true) {
            try {
                return action.execute();
            }
            catch (Exception e) {
                block7: {
                    if (++retries <= config.getAttempts() && deadlineExpiresAt > System.currentTimeMillis() && observer.shouldRetry(e)) {
                        try {
                            int ix = retries - 1;
                            long sleep = ix < backoffPolicy.length ? backoffPolicy[ix] : backoffPolicy[plen - 1];
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            break block7;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }

    public static PublishAck publish(RetryConfig config, JetStream js, String subject, Headers headers, byte[] body, PublishOptions options) throws Exception {
        return Retrier.execute(config, () -> js.publish(subject, headers, body, options), e -> e.getMessage().contains("No Responders Available For Request"));
    }

    public static PublishAck publish(RetryConfig config, JetStream js, String subject, byte[] body) throws Exception {
        return Retrier.publish(config, js, subject, null, body, null);
    }

    public static PublishAck publish(RetryConfig config, JetStream js, String subject, Headers headers, byte[] body) throws Exception {
        return Retrier.publish(config, js, subject, headers, body, null);
    }

    public static PublishAck publish(RetryConfig config, JetStream js, String subject, byte[] body, PublishOptions options) throws Exception {
        return Retrier.publish(config, js, subject, null, body, options);
    }

    public static PublishAck publish(RetryConfig config, JetStream js, Message message) throws Exception {
        return Retrier.publish(config, js, message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    public static PublishAck publish(RetryConfig config, JetStream js, Message message, PublishOptions options) throws Exception {
        return Retrier.publish(config, js, message.getSubject(), message.getHeaders(), message.getData(), options);
    }

    public static PublishAck publish(JetStream js, String subject, Headers headers, byte[] body, PublishOptions options) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, subject, headers, body, options);
    }

    public static PublishAck publish(JetStream js, String subject, byte[] body) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, subject, null, body, null);
    }

    public static PublishAck publish(JetStream js, String subject, Headers headers, byte[] body) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, subject, headers, body, null);
    }

    public static PublishAck publish(JetStream js, String subject, byte[] body, PublishOptions options) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, subject, null, body, options);
    }

    public static PublishAck publish(JetStream js, Message message) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    public static PublishAck publish(JetStream js, Message message, PublishOptions options) throws Exception {
        return Retrier.publish(RetryConfig.DEFAULT_CONFIG, js, message.getSubject(), message.getHeaders(), message.getData(), options);
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, String subject, Headers headers, byte[] body, PublishOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Retrier.publish(config, js, subject, headers, body, options);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, String subject, byte[] body) {
        return Retrier.publishAsync(config, js, subject, null, body, null);
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, String subject, Headers headers, byte[] body) {
        return Retrier.publishAsync(config, js, subject, headers, body, null);
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, String subject, byte[] body, PublishOptions options) {
        return Retrier.publishAsync(config, js, subject, null, body, options);
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, Message message) {
        return Retrier.publishAsync(config, js, message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    public static CompletableFuture<PublishAck> publishAsync(RetryConfig config, JetStream js, Message message, PublishOptions options) {
        return Retrier.publishAsync(config, js, message.getSubject(), message.getHeaders(), message.getData(), options);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, String subject, Headers headers, byte[] body, PublishOptions options) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, subject, headers, body, options);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, String subject, byte[] body) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, subject, null, body, null);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, String subject, Headers headers, byte[] body) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, subject, headers, body, null);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, String subject, byte[] body, PublishOptions options) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, subject, null, body, options);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, Message message) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    public static CompletableFuture<PublishAck> publishAsync(JetStream js, Message message, PublishOptions options) {
        return Retrier.publishAsync(RetryConfig.DEFAULT_CONFIG, js, message.getSubject(), message.getHeaders(), message.getData(), options);
    }
}

