/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OrderedConsumerConfiguration {
    public static String DEFAULT_FILTER_SUBJECT = ">";
    private final List<String> filterSubjects = new ArrayList<String>();
    private DeliverPolicy deliverPolicy;
    private Long startSequence = -1L;
    private ZonedDateTime startTime;
    private ReplayPolicy replayPolicy;
    private Boolean headersOnly;

    public OrderedConsumerConfiguration() {
        this.filterSubjects.add(DEFAULT_FILTER_SUBJECT);
    }

    public OrderedConsumerConfiguration filterSubject(String filterSubject) {
        return this.filterSubjects(Collections.singletonList(filterSubject));
    }

    public OrderedConsumerConfiguration filterSubjects(String ... filterSubject) {
        return this.filterSubjects(Arrays.asList(filterSubject));
    }

    public OrderedConsumerConfiguration filterSubjects(List<String> filterSubjects) {
        this.filterSubjects.clear();
        for (String fs : filterSubjects) {
            String fsean = Validator.emptyAsNull(fs);
            if (fsean == null) continue;
            this.filterSubjects.add(fsean);
        }
        if (this.filterSubjects.isEmpty()) {
            this.filterSubjects.add(DEFAULT_FILTER_SUBJECT);
        }
        return this;
    }

    public OrderedConsumerConfiguration deliverPolicy(DeliverPolicy deliverPolicy) {
        this.deliverPolicy = deliverPolicy;
        return this;
    }

    public OrderedConsumerConfiguration startSequence(long startSequence) {
        this.startSequence = startSequence < 1L ? -1L : startSequence;
        return this;
    }

    public OrderedConsumerConfiguration startTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OrderedConsumerConfiguration replayPolicy(ReplayPolicy replayPolicy) {
        this.replayPolicy = replayPolicy;
        return this;
    }

    public OrderedConsumerConfiguration headersOnly(Boolean headersOnly) {
        this.headersOnly = headersOnly != null && headersOnly != false ? Boolean.valueOf(true) : null;
        return this;
    }

    public String getFilterSubject() {
        return this.filterSubjects == null || this.filterSubjects.size() != 1 ? null : this.filterSubjects.get(0);
    }

    public List<String> getFilterSubjects() {
        return this.filterSubjects;
    }

    public boolean hasMultipleFilterSubjects() {
        return this.filterSubjects != null && this.filterSubjects.size() > 1;
    }

    public DeliverPolicy getDeliverPolicy() {
        return this.deliverPolicy;
    }

    public Long getStartSequence() {
        return this.startSequence;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ReplayPolicy getReplayPolicy() {
        return this.replayPolicy;
    }

    public Boolean getHeadersOnly() {
        return this.headersOnly;
    }
}

