/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.FeatureConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.NatsObjectStoreUtil;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.Map;

public class ObjectStoreConfiguration
extends FeatureConfiguration {
    ObjectStoreConfiguration(StreamConfiguration sc) {
        super(sc, NatsObjectStoreUtil.extractBucketName(sc.getName()));
    }

    public String toString() {
        return "ObjectStoreConfiguration" + this.toJson();
    }

    public boolean isSealed() {
        return this.sc.getSealed();
    }

    public static Builder builder() {
        return new Builder((ObjectStoreConfiguration)null);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(ObjectStoreConfiguration osc) {
        return new Builder(osc);
    }

    public static class Builder
    extends FeatureConfiguration.Builder<Builder, ObjectStoreConfiguration> {
        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder() {
            this((ObjectStoreConfiguration)null);
        }

        public Builder(String name) {
            this((ObjectStoreConfiguration)null);
            this.name(name);
        }

        public Builder(ObjectStoreConfiguration osc) {
            if (osc == null) {
                this.scBuilder = new StreamConfiguration.Builder();
                this.replicas(1);
            } else {
                this.scBuilder = new StreamConfiguration.Builder(osc.sc);
                this.name = NatsObjectStoreUtil.extractBucketName(osc.sc.getName());
            }
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        @Override
        public Builder maxBucketSize(long maxBucketSize) {
            return (Builder)super.maxBucketSize(maxBucketSize);
        }

        @Override
        public Builder ttl(Duration ttl) {
            return (Builder)super.ttl(ttl);
        }

        @Override
        public Builder storageType(StorageType storageType) {
            return (Builder)super.storageType(storageType);
        }

        @Override
        public Builder replicas(int replicas) {
            return (Builder)super.replicas(replicas);
        }

        @Override
        public Builder placement(Placement placement) {
            return (Builder)super.placement(placement);
        }

        @Override
        public Builder compression(boolean compression) {
            return (Builder)super.compression(compression);
        }

        @Override
        public Builder metadata(Map<String, String> metadata) {
            return (Builder)super.metadata(metadata);
        }

        @Override
        public ObjectStoreConfiguration build() {
            this.name = Validator.required(this.name, "name");
            this.scBuilder.name(NatsObjectStoreUtil.toStreamName(this.name)).subjects(NatsObjectStoreUtil.toMetaStreamSubject(this.name), NatsObjectStoreUtil.toChunkStreamSubject(this.name)).allowRollup(true).allowDirect(true).discardPolicy(DiscardPolicy.New);
            return new ObjectStoreConfiguration(this.scBuilder.build());
        }
    }
}

