/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.ObjectLink;
import io.nats.client.api.ObjectMeta;
import io.nats.client.api.ObjectMetaOptions;
import io.nats.client.impl.Headers;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;

public class ObjectInfo
implements JsonSerializable {
    private final String bucket;
    private final String nuid;
    private final long size;
    private final long chunks;
    private final String digest;
    private final boolean deleted;
    private final ObjectMeta objectMeta;
    private ZonedDateTime modified;

    private ObjectInfo(Builder b) {
        this.bucket = b.bucket;
        this.nuid = b.nuid;
        this.size = b.size;
        this.modified = b.modified;
        this.chunks = b.chunks;
        this.digest = b.digest;
        this.deleted = b.deleted;
        this.objectMeta = b.metaBuilder.build();
    }

    public ObjectInfo(MessageInfo mi) {
        this(mi.getData(), mi.getTime());
    }

    public ObjectInfo(Message m) {
        this(m.getData(), m.metaData().timestamp());
    }

    ObjectInfo(byte[] jsonBytes, ZonedDateTime messageTime) {
        JsonValue jv = JsonParser.parseUnchecked(jsonBytes);
        this.objectMeta = new ObjectMeta(jv);
        this.bucket = JsonValueUtils.readString(jv, "bucket");
        this.nuid = JsonValueUtils.readString(jv, "nuid");
        this.size = JsonValueUtils.readLong(jv, "size", 0L);
        this.modified = DateTimeUtils.toGmt(messageTime);
        this.chunks = JsonValueUtils.readLong(jv, "chunks", 0L);
        this.digest = JsonValueUtils.readString(jv, "digest");
        this.deleted = JsonValueUtils.readBoolean(jv, "deleted");
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        this.objectMeta.embedJson(sb);
        JsonUtils.addField(sb, "bucket", this.bucket);
        JsonUtils.addField(sb, "nuid", this.nuid);
        JsonUtils.addField(sb, "size", this.size);
        JsonUtils.addField(sb, "chunks", this.chunks);
        JsonUtils.addField(sb, "digest", this.digest);
        JsonUtils.addField(sb, "deleted", this.deleted);
        return JsonUtils.endJson(sb).toString();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getNuid() {
        return this.nuid;
    }

    public long getSize() {
        return this.size;
    }

    public ZonedDateTime getModified() {
        return this.modified;
    }

    public long getChunks() {
        return this.chunks;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public ObjectMeta getObjectMeta() {
        return this.objectMeta;
    }

    public String getObjectName() {
        return this.objectMeta.getObjectName();
    }

    public String getDescription() {
        return this.objectMeta.getDescription();
    }

    public Headers getHeaders() {
        return this.objectMeta.getHeaders();
    }

    public boolean isLink() {
        return this.objectMeta.getObjectMetaOptions().getLink() != null;
    }

    public ObjectLink getLink() {
        return this.objectMeta.getObjectMetaOptions().getLink();
    }

    public static Builder builder(String bucket, String objectName) {
        return new Builder(bucket, objectName);
    }

    public static Builder builder(String bucket, ObjectMeta meta) {
        return new Builder(bucket, meta);
    }

    public static Builder builder(ObjectInfo info) {
        return new Builder(info);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectInfo info = (ObjectInfo)o;
        if (this.size != info.size) {
            return false;
        }
        if (this.chunks != info.chunks) {
            return false;
        }
        if (this.deleted != info.deleted) {
            return false;
        }
        if (!this.bucket.equals(info.bucket)) {
            return false;
        }
        if (this.nuid != null ? !this.nuid.equals(info.nuid) : info.nuid != null) {
            return false;
        }
        if (this.modified != null ? !this.modified.equals(info.modified) : info.modified != null) {
            return false;
        }
        if (this.digest != null ? !this.digest.equals(info.digest) : info.digest != null) {
            return false;
        }
        return this.objectMeta.equals(info.objectMeta);
    }

    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + (this.nuid != null ? this.nuid.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.modified != null ? this.modified.hashCode() : 0);
        result = 31 * result + (int)(this.chunks ^ this.chunks >>> 32);
        result = 31 * result + (this.digest != null ? this.digest.hashCode() : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + this.objectMeta.hashCode();
        return result;
    }

    public String toString() {
        return "ObjectInfo{bucket='" + this.bucket + '\'' + ", nuid='" + this.nuid + '\'' + ", size=" + this.size + ", modified=" + this.modified + ", chunks=" + this.chunks + ", digest='" + this.digest + '\'' + ", deleted=" + this.deleted + ", objectMeta=" + this.objectMeta + '}';
    }

    public static class Builder {
        String bucket;
        String nuid;
        long size;
        ZonedDateTime modified;
        long chunks;
        String digest;
        boolean deleted;
        ObjectMeta.Builder metaBuilder;

        public Builder(String bucket, String objectName) {
            this.metaBuilder = ObjectMeta.builder(objectName);
            this.bucket(bucket);
        }

        public Builder(String bucket, ObjectMeta meta) {
            this.metaBuilder = ObjectMeta.builder(meta);
            this.bucket(bucket);
        }

        public Builder(ObjectInfo info) {
            this.bucket = info.bucket;
            this.nuid = info.nuid;
            this.size = info.size;
            this.modified = info.modified;
            this.chunks = info.chunks;
            this.digest = info.digest;
            this.deleted = info.deleted;
            this.metaBuilder = ObjectMeta.builder(info.objectMeta);
        }

        public Builder objectName(String name) {
            this.metaBuilder.objectName(name);
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = Validator.validateBucketName(bucket, true);
            return this;
        }

        public Builder nuid(String nuid) {
            this.nuid = nuid;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder modified(ZonedDateTime modified) {
            this.modified = modified;
            return this;
        }

        public Builder chunks(long chunks) {
            this.chunks = chunks;
            return this;
        }

        public Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder description(String description) {
            this.metaBuilder.description(description);
            return this;
        }

        public Builder headers(Headers headers) {
            this.metaBuilder.headers(headers);
            return this;
        }

        public Builder options(ObjectMetaOptions objectMetaOptions) {
            this.metaBuilder.options(objectMetaOptions);
            return this;
        }

        public Builder chunkSize(int chunkSize) {
            this.metaBuilder.chunkSize(chunkSize);
            return this;
        }

        public Builder link(ObjectLink link) {
            this.metaBuilder.link(link);
            return this;
        }

        public Builder bucketLink(String bucket) {
            this.metaBuilder.link(ObjectLink.bucket(bucket));
            return this;
        }

        public Builder objectLink(String bucket, String objectName) {
            this.metaBuilder.link(ObjectLink.object(bucket, objectName));
            return this;
        }

        public ObjectInfo build() {
            return new ObjectInfo(this);
        }
    }
}

