/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import io.nats.client.support.Status;

public interface ErrorListener {
    default public void errorOccurred(Connection conn, String error) {
    }

    default public void exceptionOccurred(Connection conn, Exception exp) {
    }

    default public void slowConsumerDetected(Connection conn, Consumer consumer) {
    }

    default public void messageDiscarded(Connection conn, Message msg) {
    }

    default public void heartbeatAlarm(Connection conn, JetStreamSubscription sub, long lastStreamSequence, long lastConsumerSequence) {
    }

    default public void unhandledStatus(Connection conn, JetStreamSubscription sub, Status status) {
    }

    default public void pullStatusWarning(Connection conn, JetStreamSubscription sub, Status status) {
    }

    default public void pullStatusError(Connection conn, JetStreamSubscription sub, Status status) {
    }

    default public void flowControlProcessed(Connection conn, JetStreamSubscription sub, String subject, FlowControlSource source) {
    }

    default public void socketWriteTimeout(Connection conn) {
    }

    default public String supplyMessage(String label, Connection conn, Consumer consumer, Subscription sub, Object ... pairs) {
        ServerInfo si;
        StringBuilder sb = new StringBuilder(label == null ? "" : label);
        if (conn != null && (si = conn.getServerInfo()) != null) {
            sb.append(", Connection: ").append(conn.getServerInfo().getClientId());
        }
        if (consumer != null) {
            sb.append(", Consumer: ").append(consumer.hashCode());
        }
        if (sub != null) {
            sb.append(", Subscription: ").append(sub.hashCode());
            if (sub instanceof JetStreamSubscription) {
                JetStreamSubscription jssub = (JetStreamSubscription)sub;
                sb.append(", Consumer Name: ").append(jssub.getConsumerName());
            }
        }
        for (int x = 0; x < pairs.length; ++x) {
            sb.append(", ").append(pairs[x]).append(pairs[++x]);
        }
        return sb.toString();
    }

    public static enum FlowControlSource {
        FLOW_CONTROL,
        HEARTBEAT;

    }
}

