/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonSerializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JsonUtils {
    public static final String EMPTY_JSON = "{}";
    private static final String STRING_RE = "\\s*\"(.+?)\"";
    private static final String BOOLEAN_RE = "\\s*(true|false)";
    private static final String NUMBER_RE = "\\s*(\\d+)";
    private static final String STRING_ARRAY_RE = "\\s*\\[\\s*(\".+?\")\\s*\\]";
    private static final String BEFORE_FIELD_RE = "\"";
    private static final String AFTER_FIELD_RE = "\"\\s*:\\s*";
    private static final String Q = "\"";
    private static final String QCOLONQ = "\":\"";
    private static final String QCOLON = "\":";
    private static final String QCOMMA = "\",";
    private static final String COMMA = ",";
    public static final String OPENQ = "{\"";
    public static final String CLOSE = "}";
    private static final String INDENT = "                                ";

    private JsonUtils() {
    }

    public static Pattern string_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_RE);
    }

    public static Pattern number_pattern(String field) {
        return JsonUtils.buildPattern(field, NUMBER_RE);
    }

    public static Pattern boolean_pattern(String field) {
        return JsonUtils.buildPattern(field, BOOLEAN_RE);
    }

    public static Pattern string_array_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_ARRAY_RE);
    }

    public static Pattern buildPattern(String fieldName, FieldType type) {
        return JsonUtils.buildPattern(fieldName, type.re);
    }

    public static Pattern buildPattern(String fieldName, String typeRE) {
        return Pattern.compile("\"" + fieldName + AFTER_FIELD_RE + typeRE, 2);
    }

    public static String getJsonObject(String objectName, String json) {
        return JsonUtils.getJsonObject(objectName, json, EMPTY_JSON);
    }

    public static String getJsonObject(String objectName, String json, String dflt) {
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '{', '}', 0);
        return indexes == null ? dflt : json.substring(indexes[0], indexes[1] + 1);
    }

    public static List<String> getObjectList(String objectName, String json) {
        ArrayList<String> items = new ArrayList<String>();
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '[', ']', -1);
        if (indexes != null) {
            StringBuilder item = new StringBuilder();
            int depth = 0;
            for (int x = indexes[0] + 1; x < indexes[1]; ++x) {
                char c = json.charAt(x);
                if (c == '{') {
                    item.append(c);
                    ++depth;
                    continue;
                }
                if (c == '}') {
                    item.append(c);
                    if (--depth != 0) continue;
                    items.add(item.toString());
                    item.setLength(0);
                    continue;
                }
                if (depth <= 0) continue;
                item.append(c);
            }
        }
        return items;
    }

    private static int[] getBracketIndexes(String objectName, String json, char start, char end, int fromIndex) {
        int[] result = new int[]{-1, -1};
        int objStart = json.indexOf("\"" + objectName + "\"", fromIndex);
        if (objStart != -1) {
            char c;
            int x;
            int startIx;
            if (fromIndex != -1) {
                int colonMark = json.indexOf(58, objStart) + 1;
                startIx = json.indexOf(start, colonMark);
                for (x = colonMark; x < startIx; ++x) {
                    c = json.charAt(x);
                    if (Character.isWhitespace(c)) continue;
                    return JsonUtils.getBracketIndexes(objectName, json, start, end, colonMark);
                }
            } else {
                startIx = json.indexOf(start, objStart);
            }
            int depth = 1;
            for (x = startIx + 1; x < json.length(); ++x) {
                c = json.charAt(x);
                if (c == start) {
                    ++depth;
                    continue;
                }
                if (c != end || --depth != 0) continue;
                result[0] = startIx;
                result[1] = x;
                return result;
            }
        }
        return null;
    }

    public static List<String> getStringList(String objectName, String json) {
        String flat = json.replaceAll("\r", "").replaceAll("\n", "");
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = JsonUtils.string_array_pattern(objectName).matcher(flat);
        if (m.find()) {
            String[] raw;
            String arrayString = m.group(1);
            for (String s : raw = arrayString.split(COMMA)) {
                String cleaned = s.trim().replace("\"", "");
                if (cleaned.length() <= 0) continue;
                list.add(JsonUtils.decode(cleaned));
            }
        }
        return list;
    }

    public static byte[] simpleMessageBody(String name, Object value) {
        return (OPENQ + name + QCOLON + value + CLOSE).getBytes();
    }

    public static StringBuilder beginJson() {
        return new StringBuilder("{");
    }

    public static StringBuilder beginJsonPrefixed(String prefix) {
        return prefix == null ? JsonUtils.beginJson() : new StringBuilder(prefix).append(" ").append('{');
    }

    public static StringBuilder endJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append(CLOSE);
        return sb;
    }

    public static StringBuilder beginFormattedJson() {
        return new StringBuilder("{\n    ");
    }

    public static String endFormattedJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append("\n}");
        return sb.toString().replaceAll(COMMA, ",\n    ");
    }

    public static void addField(StringBuilder sb, String fname, String value) {
        if (value != null && value.length() > 0) {
            sb.append("\"").append(fname).append(QCOLONQ).append(value).append(QCOMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, boolean value) {
        sb.append("\"").append(fname).append(QCOLON).append(value ? "true" : "false").append(COMMA);
    }

    public static void addFldWhenTrue(StringBuilder sb, String fname, Boolean value) {
        if (value != null && value.booleanValue()) {
            JsonUtils.addField(sb, fname, true);
        }
    }

    public static void addField(StringBuilder sb, String fname, long value) {
        if (value >= 0L) {
            sb.append("\"").append(fname).append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldAsNanos(StringBuilder sb, String fname, Duration value) {
        if (value != null && value != Duration.ZERO) {
            sb.append("\"").append(fname).append(QCOLON).append(value.toNanos()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, JsonSerializable value) {
        if (value != null) {
            sb.append("\"").append(fname).append(QCOLON).append(value.toJson()).append(COMMA);
        }
    }

    public static void addStrings(StringBuilder sb, String fname, String[] strArray) {
        if (strArray == null || strArray.length == 0) {
            return;
        }
        JsonUtils.addStrings(sb, fname, Arrays.asList(strArray));
    }

    public static void addStrings(StringBuilder sb, String fname, List<String> strings) {
        if (strings == null || strings.size() == 0) {
            return;
        }
        sb.append("\"").append(fname).append("\":[");
        for (int i = 0; i < strings.size(); ++i) {
            String s = strings.get(i);
            sb.append("\"").append(s).append("\"");
            if (i >= strings.size() - 1) continue;
            sb.append(COMMA);
        }
        sb.append("],");
    }

    public static void addJsons(StringBuilder sb, String fname, List<? extends JsonSerializable> jsons) {
        if (jsons == null || jsons.size() == 0) {
            return;
        }
        sb.append("\"").append(fname).append("\":[");
        for (int i = 0; i < jsons.size(); ++i) {
            JsonSerializable s = jsons.get(i);
            sb.append(s.toJson());
            if (i >= jsons.size() - 1) continue;
            sb.append(COMMA);
        }
        sb.append("],");
    }

    public static void addField(StringBuilder sb, String fname, ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            sb.append("\"").append(fname).append(QCOLONQ).append(DateTimeUtils.toRfc3339(zonedDateTime)).append(QCOMMA);
        }
    }

    public static String readString(String json, Pattern pattern) {
        return JsonUtils.readString(json, pattern, null);
    }

    public static String readString(String json, Pattern pattern, String dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? JsonUtils.decode(m.group(1)) : dflt;
    }

    public static byte[] readBytes(String json, Pattern pattern) {
        String s = JsonUtils.readString(json, pattern, null);
        return s == null ? null : s.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] readBase64(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        String b64 = m.find() ? m.group(1) : null;
        return b64 == null ? null : Base64.getDecoder().decode(b64);
    }

    public static boolean readBoolean(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() && Boolean.parseBoolean(m.group(1));
    }

    public static int readInt(String json, Pattern pattern, int dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Integer.parseInt(m.group(1)) : dflt;
    }

    public static void readInt(String json, Pattern pattern, IntConsumer c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Integer.parseInt(m.group(1)));
        }
    }

    public static long readLong(String json, Pattern pattern, long dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Long.parseLong(m.group(1)) : dflt;
    }

    public static void readLong(String json, Pattern pattern, LongConsumer c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Long.parseLong(m.group(1)));
        }
    }

    public static ZonedDateTime readDate(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? DateTimeUtils.parseDateTime(m.group(1)) : null;
    }

    public static Duration readNanos(String json, Pattern pattern, Duration dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Duration.ofNanos(Long.parseLong(m.group(1))) : dflt;
    }

    public static void readNanos(String json, Pattern pattern, Consumer<Duration> c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Duration.ofNanos(Long.parseLong(m.group(1))));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String decode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        int x = 0;
        while (true) {
            block13: {
                int ch;
                block12: {
                    if (x >= len) {
                        return sb.toString();
                    }
                    ch = s.charAt(x);
                    if (ch != 92) break block12;
                    int nextChar = x == len - 1 ? 92 : (int)s.charAt(x + 1);
                    switch (nextChar) {
                        case 92: {
                            ch = 92;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 117: {
                            if (x >= len - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + s.charAt(x + 2) + s.charAt(x + 3) + s.charAt(x + 4) + s.charAt(x + 5), 16);
                            sb.append(Character.toChars(code));
                            x += 5;
                            break block13;
                        }
                    }
                    ++x;
                }
                sb.append((char)ch);
            }
            ++x;
        }
    }

    public static String normalize(String s) {
        return Character.toString(s.charAt(0)).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String objectString(String name, Object o) {
        return o == null ? name + "=null" : o.toString();
    }

    private static String indent(int level) {
        return level == 0 ? "" : INDENT.substring(0, level * 4);
    }

    public static void printFormatted(Object o) {
        int level = 0;
        boolean indentNext = true;
        String s = o.toString();
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '{') {
                System.out.print(c + "\n");
                ++level;
                indentNext = true;
                continue;
            }
            if (c == '}') {
                System.out.print("\n" + JsonUtils.indent(--level) + c);
                continue;
            }
            if (c == ',') {
                System.out.print("\n");
                indentNext = true;
                continue;
            }
            if (indentNext) {
                if (c == ' ') continue;
                System.out.print(JsonUtils.indent(level) + c);
                indentNext = false;
                continue;
            }
            System.out.print(c);
        }
        System.out.println();
    }

    public static enum FieldType {
        jsonString("\\s*\"(.+?)\""),
        jsonBoolean("\\s*(true|false)"),
        jsonNumber("\\s*(\\d+)"),
        jsonStringArray("\\s*\\[\\s*(\".+?\")\\s*\\]");

        final String re;

        private FieldType(String re) {
            this.re = re;
        }
    }
}

