/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsJetStreamMessage;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.JsPrefixManager;
import io.nats.client.support.NatsConstants;
import io.nats.client.support.Status;
import io.nats.client.support.Validator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class NatsMessage
implements Message {
    protected static final String NOT_A_JET_STREAM_MESSAGE = "Message is not a JetStream message";
    protected String subject;
    protected String replyTo;
    protected byte[] data;
    protected boolean utf8mode;
    protected Headers headers;
    protected String sid;
    protected int protocolLineLength;
    protected byte[] protocolBytes;
    protected int sizeInBytes = -1;
    protected int hdrLen = 0;
    protected int dataLen = 0;
    protected int totLen = 0;
    protected boolean dirty = false;
    protected NatsSubscription subscription;
    NatsMessage next;

    private NatsMessage() {
        this.data = NatsConstants.EMPTY_BODY;
    }

    private NatsMessage(byte[] data) {
        this.data = data == null ? NatsConstants.EMPTY_BODY : data;
    }

    public NatsMessage(String subject, String replyTo, byte[] data, boolean utf8mode) {
        this(subject, replyTo, null, data, utf8mode);
    }

    public NatsMessage(Message message) {
        this(message.getSubject(), message.getReplyTo(), message.getHeaders(), message.getData(), message.isUtf8mode());
    }

    public NatsMessage(String subject, String replyTo, Headers headers, byte[] data, boolean utf8mode) {
        this(data);
        Validator.validateMessageSubjectRequired(subject);
        Validator.validateReplyToNullButNotEmpty(replyTo);
        this.subject = subject;
        this.replyTo = replyTo;
        this.headers = headers;
        this.utf8mode = utf8mode;
        this.dirty = true;
    }

    protected boolean calculateIfDirty() {
        if (this.dirty || this.hasHeaders() && this.headers.isDirty()) {
            int replyToLen = this.replyTo == null ? 0 : this.replyTo.length();
            this.dataLen = this.data.length;
            this.hdrLen = this.headers != null && !this.headers.isEmpty() ? this.headers.serializedLength() : 0;
            this.totLen = this.hdrLen + this.dataLen;
            ByteArrayBuilder bab = new ByteArrayBuilder(32 + this.subject.length() * 2 + replyToLen + this.totLen);
            if (this.hdrLen > 0) {
                bab.append(NatsConstants.HPUB_SP_BYTES);
            } else {
                bab.append(NatsConstants.PUB_SP_BYTES);
            }
            bab.append(this.subject, this.utf8mode ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII);
            bab.appendSpace();
            if (replyToLen > 0) {
                bab.append(this.replyTo);
                bab.appendSpace();
            }
            if (this.hdrLen > 0) {
                bab.append(Integer.toString(this.hdrLen));
                bab.appendSpace();
            }
            bab.append(Integer.toString(this.totLen));
            this.protocolBytes = bab.toByteArray();
            this.dirty = false;
            return true;
        }
        return false;
    }

    long getSizeInBytes() {
        if (this.calculateIfDirty() || this.sizeInBytes == -1) {
            this.sizeInBytes = this.protocolLineLength;
            if (this.protocolBytes != null) {
                this.sizeInBytes += this.protocolBytes.length;
            }
            if (this.hdrLen > 0) {
                this.sizeInBytes += this.hdrLen + 2;
            }
            this.sizeInBytes = this.data.length == 0 ? (this.sizeInBytes += 2) : (this.sizeInBytes += this.dataLen + 4);
        }
        return this.sizeInBytes;
    }

    boolean isProtocol() {
        return false;
    }

    byte[] getProtocolBytes() {
        this.calculateIfDirty();
        return this.protocolBytes;
    }

    int getControlLineLength() {
        this.calculateIfDirty();
        return this.protocolBytes != null ? this.protocolBytes.length + 2 : -1;
    }

    Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers();
        }
        return this.headers;
    }

    void setSubscription(NatsSubscription sub) {
        this.subscription = sub;
    }

    NatsSubscription getNatsSubscription() {
        return this.subscription;
    }

    @Override
    public String getSID() {
        return this.sid;
    }

    @Override
    public Connection getConnection() {
        return this.subscription == null ? null : this.subscription.connection;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getReplyTo() {
        return this.replyTo;
    }

    byte[] getSerializedHeader() {
        return this.hasHeaders() ? this.headers.getSerialized() : null;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStatusMessage() {
        return false;
    }

    @Override
    public Status getStatus() {
        return null;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public boolean isUtf8mode() {
        return this.utf8mode;
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public void ack() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public void ackSync(Duration d) throws InterruptedException, TimeoutException {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public void nak() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public void inProgress() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public void term() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public NatsJetStreamMetaData metaData() {
        throw new IllegalStateException(NOT_A_JET_STREAM_MESSAGE);
    }

    @Override
    public boolean isJetStream() {
        return false;
    }

    public String toString() {
        if (this.subject == null) {
            return "NatsMessage | " + new String(this.protocolBytes);
        }
        return "NatsMessage |" + this.subject + "|" + this.replyToString() + "|" + this.dataToString() + "|";
    }

    String toDetailString() {
        this.calculateIfDirty();
        return "NatsMessage:\n  subject='" + this.subject + '\'' + "\n  replyTo='" + this.replyToString() + '\'' + "\n  data=" + this.dataToString() + "\n  utf8mode=" + this.utf8mode + "\n  headers=" + this.headersToString() + "\n  sid='" + this.sid + '\'' + "\n  protocolLineLength=" + this.protocolLineLength + "\n  protocolBytes=" + this.protocolBytesToString() + "\n  sizeInBytes=" + this.sizeInBytes + "\n  hdrLen=" + this.hdrLen + "\n  dataLen=" + this.dataLen + "\n  totLen=" + this.totLen + "\n  subscription=" + this.subscription + "\n  next=" + this.nextToString();
    }

    private String headersToString() {
        return this.hasHeaders() ? new String(this.headers.getSerialized(), StandardCharsets.US_ASCII).replace("\r", "+").replace("\n", "+") : "";
    }

    private String dataToString() {
        return this.data.length == 0 ? "<no data>" : new String(this.data, StandardCharsets.UTF_8);
    }

    private String replyToString() {
        return this.replyTo == null ? "<no reply>" : this.replyTo;
    }

    private String protocolBytesToString() {
        return this.protocolBytes == null ? null : new String(this.protocolBytes, StandardCharsets.UTF_8);
    }

    private String nextToString() {
        return this.next == null ? "No" : "Yes";
    }

    public static Builder builder() {
        return new Builder();
    }

    static class StatusMessage
    extends InternalMessage {
        private final Status status;

        public StatusMessage(Status status) {
            this.status = status;
        }

        @Override
        public boolean isStatusMessage() {
            return true;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public String toString() {
            return "StatusMessage{code=" + this.status.getCode() + ", message='" + this.status.getMessage() + '\'' + '}';
        }
    }

    static class ProtocolMessage
    extends InternalMessage {
        ProtocolMessage(byte[] protocol) {
            this.protocolBytes = protocol == null ? NatsConstants.EMPTY_BODY : protocol;
        }

        ProtocolMessage(ByteArrayBuilder babProtocol) {
            this(babProtocol.toByteArray());
        }

        ProtocolMessage(String asciiProtocol) {
            this(asciiProtocol.getBytes(StandardCharsets.US_ASCII));
        }

        @Override
        boolean isProtocol() {
            return true;
        }
    }

    static class InternalMessage
    extends NatsMessage {
        InternalMessage() {
        }

        @Override
        protected boolean calculateIfDirty() {
            return false;
        }
    }

    static class InternalMessageFactory {
        private final String sid;
        private final String subject;
        private final String replyTo;
        private final int protocolLineLength;
        private final boolean utf8mode;
        private byte[] data;
        private Headers headers;
        private Status status;
        private int hdrLen = 0;
        private int dataLen = 0;
        private int totLen = 0;

        InternalMessageFactory(String sid, String subject, String replyTo, int protocolLength, boolean utf8mode) {
            this.sid = sid;
            this.subject = subject;
            this.replyTo = replyTo;
            this.protocolLineLength = protocolLength;
            this.utf8mode = utf8mode;
        }

        void setHeaders(IncomingHeadersProcessor ihp) {
            this.headers = ihp.getHeaders();
            this.status = ihp.getStatus();
            this.hdrLen = ihp.getSerializedLength();
            this.totLen = this.hdrLen + this.dataLen;
        }

        void setData(byte[] data) {
            this.data = data;
            this.dataLen = data == null ? 0 : data.length;
            this.totLen = this.hdrLen + this.dataLen;
        }

        NatsMessage getMessage() {
            InternalMessage message = null;
            if (this.status != null) {
                message = new StatusMessage(this.status);
            } else if (JsPrefixManager.hasPrefix(this.replyTo)) {
                message = new NatsJetStreamMessage();
            }
            if (message == null) {
                message = new InternalMessage();
            }
            message.sid = this.sid;
            message.subject = this.subject;
            message.replyTo = this.replyTo;
            message.protocolLineLength = this.protocolLineLength;
            message.headers = this.headers;
            message.data = this.data == null ? NatsConstants.EMPTY_BODY : this.data;
            message.utf8mode = this.utf8mode;
            message.hdrLen = this.hdrLen;
            message.dataLen = this.dataLen;
            message.totLen = this.totLen;
            return message;
        }
    }

    public static class Builder {
        private String subject;
        private String replyTo;
        private Headers headers;
        private byte[] data;
        private boolean utf8mode;

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder replyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder data(String data) {
            if (data != null) {
                this.data = data.getBytes(StandardCharsets.UTF_8);
            }
            return this;
        }

        public Builder data(String data, Charset charset) {
            this.data = data.getBytes(charset);
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder utf8mode(boolean utf8mode) {
            this.utf8mode = utf8mode;
            return this;
        }

        public NatsMessage build() {
            return new NatsMessage(this.subject, this.replyTo, this.headers, this.data, this.utf8mode);
        }
    }
}

