/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.time.Duration;

public class PeerInfo {
    private final String name;
    private final boolean current;
    private final boolean offline;
    private final Duration active;
    private final long lag;
    private final String objectName;

    PeerInfo(String objectName, String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.current = JsonUtils.readBoolean(json, ApiConstants.CURRENT_RE);
        this.offline = JsonUtils.readBoolean(json, ApiConstants.OFFLINE_RE);
        this.active = JsonUtils.readNanos(json, ApiConstants.ACTIVE_RE, Duration.ZERO);
        this.lag = JsonUtils.readLong(json, ApiConstants.LAG_RE, 0L);
        this.objectName = JsonUtils.normalize(objectName);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Duration getActive() {
        return this.active;
    }

    public long getLag() {
        return this.lag;
    }

    public String toString() {
        return this.objectName + "{name='" + this.name + '\'' + ", current=" + this.current + ", offline=" + this.offline + ", active=" + this.active + ", lag=" + this.lag + '}';
    }
}

