/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.impl.Headers;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.JsonUtils;
import java.time.ZonedDateTime;

public class MessageInfo
extends ApiResponse<MessageInfo> {
    private final String subject;
    private final long seq;
    private final byte[] data;
    private final ZonedDateTime time;
    private final Headers headers;

    public MessageInfo(Message msg) {
        super(msg);
        this.subject = JsonUtils.readString(this.json, ApiConstants.SUBJECT_RE);
        this.data = JsonUtils.readBase64(this.json, ApiConstants.DATA_RE);
        this.seq = JsonUtils.readLong(this.json, ApiConstants.SEQ_RE, 0L);
        this.time = JsonUtils.readDate(this.json, ApiConstants.TIME_RE);
        byte[] hdrBytes = JsonUtils.readBase64(this.json, ApiConstants.HDRS_RE);
        this.headers = hdrBytes == null ? null : new IncomingHeadersProcessor(hdrBytes).getHeaders();
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte[] getData() {
        return this.data;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "MessageInfo{subject='" + this.subject + '\'' + ", seq=" + this.seq + ", data='" + this.data + '\'' + ", time=" + this.time + ", headers=" + this.headers + '}';
    }
}

