/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.Validator;

public class PullSubscribeOptions
extends SubscribeOptions {
    private PullSubscribeOptions(String stream, ConsumerConfiguration consumerConfig) {
        super(stream, consumerConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SubscribeOptions.Builder<Builder, PullSubscribeOptions> {
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public PullSubscribeOptions build() {
            Validator.validateStreamNameOrEmptyAsNull(this.stream);
            this.durable = Validator.validateDurableRequired(this.durable, this.consumerConfig);
            ConsumerConfiguration cc = ConsumerConfiguration.builder(this.consumerConfig).durable(this.durable).build();
            return new PullSubscribeOptions(this.stream, cc);
        }
    }
}

