/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.RandomUtils;

public final class NUID {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int base = 62;
    static final int preLen = 12;
    static final int seqLen = 10;
    static final long maxSeq = 839299365868340224L;
    static final long minInc = 33L;
    static final long maxInc = 333L;
    static final int totalLen = 22;
    char[] pre;
    private long seq = RandomUtils.nextLong(RandomUtils.PRAND, 839299365868340224L);
    private long inc = 33L + RandomUtils.nextLong(RandomUtils.PRAND, 300L);
    private static final NUID globalNUID = new NUID();

    static NUID getInstance() {
        return globalNUID;
    }

    public NUID() {
        this.pre = new char[12];
        for (int i = 0; i < 12; ++i) {
            this.pre[i] = 48;
        }
        this.randomizePrefix();
    }

    public static synchronized String nextGlobal() {
        return globalNUID.next();
    }

    public final synchronized String next() {
        this.seq += this.inc;
        if (this.seq >= 839299365868340224L) {
            this.randomizePrefix();
            this.resetSequential();
        }
        char[] b = new char[22];
        System.arraycopy(this.pre, 0, b, 0, 12);
        int i = b.length;
        long l = this.seq;
        while (i > 12) {
            b[--i] = digits[(int)(l % 62L)];
            l /= 62L;
        }
        return new String(b);
    }

    void resetSequential() {
        this.seq = RandomUtils.nextLong(RandomUtils.PRAND, 839299365868340224L);
        this.inc = 33L + RandomUtils.nextLong(RandomUtils.PRAND, 300L);
    }

    final void randomizePrefix() {
        byte[] cb = new byte[12];
        RandomUtils.SRAND.nextBytes(cb);
        for (int i = 0; i < 12; ++i) {
            this.pre[i] = digits[(cb[i] & 0xFF) % 62];
        }
    }

    char[] getPre() {
        return this.pre;
    }

    long getSeq() {
        return this.seq;
    }

    void setSeq(long seq) {
        this.seq = seq;
    }
}

