/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl;

import io.mockk.impl.InternalPlatform;
import io.mockk.impl.MultiNotifier;
import io.mockk.impl.Ref;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u001e\u0010\u001f\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lio/mockk/impl/JvmMultiNotifier;", "Lio/mockk/impl/MultiNotifier;", "()V", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "conditionMet", "", "Lio/mockk/impl/Ref;", "getConditionMet", "()Ljava/util/Set;", "counters", "", "", "getCounters", "()Ljava/util/Map;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "changeCounters", "", "keys", "", "", "delta", "checkAnyConditionsMet", "", "notify", "key", "openSession", "Lio/mockk/impl/MultiNotifier$Session;", "timeout", "", "time", "SessionImpl", "mockk"})
@SourceDebugExtension(value={"SMAP\nJvmMultiNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmMultiNotifier.kt\nio/mockk/impl/JvmMultiNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1747#2,3:85\n1855#2:88\n1856#2:90\n1#3:89\n*S KotlinDebug\n*F\n+ 1 JvmMultiNotifier.kt\nio/mockk/impl/JvmMultiNotifier\n*L\n57#1:85,3\n62#1:88\n62#1:90\n*E\n"})
public final class JvmMultiNotifier
implements MultiNotifier {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final Condition condition;
    @NotNull
    private final Set<Ref> conditionMet;
    @NotNull
    private final Map<Ref, Integer> counters;

    public JvmMultiNotifier() {
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"lock.newCondition()");
        this.condition = condition;
        this.conditionMet = new LinkedHashSet();
        this.counters = new LinkedHashMap();
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @NotNull
    public final Condition getCondition() {
        return this.condition;
    }

    @NotNull
    public final Set<Ref> getConditionMet() {
        return this.conditionMet;
    }

    @NotNull
    public final Map<Ref, Integer> getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MultiNotifier.Session openSession(@NotNull List<? extends Object> keys, long timeout) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        long start = this.time();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.changeCounters(keys, 1);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return new SessionImpl(start, timeout, keys);
    }

    private final boolean checkAnyConditionsMet(List<? extends Object> keys) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = keys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!this.conditionMet.contains(InternalPlatform.INSTANCE.ref(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final long time() {
        return System.currentTimeMillis();
    }

    private final void changeCounters(List<? extends Object> keys, int delta) {
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int value;
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            Ref ref = InternalPlatform.INSTANCE.ref(it);
            Integer n = this.counters.get(ref);
            if (n == null) {
                boolean bl2 = false;
                n = 0;
            }
            if ((value = ((Number)n).intValue() + delta) == 0) {
                this.conditionMet.remove(ref);
                this.counters.remove(ref);
                continue;
            }
            Integer n2 = value;
            this.counters.put(ref, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Ref ref = InternalPlatform.INSTANCE.ref(key);
            if (this.counters.containsKey(ref)) {
                this.conditionMet.add(ref);
            }
            this.condition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mockk/impl/JvmMultiNotifier$SessionImpl;", "Lio/mockk/impl/MultiNotifier$Session;", "start", "", "timeout", "keys", "", "", "(Lio/mockk/impl/JvmMultiNotifier;JJLjava/util/List;)V", "close", "", "wait", "", "mockk"})
    public final class SessionImpl
    implements MultiNotifier.Session {
        private final long start;
        private final long timeout;
        @NotNull
        private final List<Object> keys;

        public SessionImpl(long start, @NotNull long timeout, List<? extends Object> keys) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            this.start = start;
            this.timeout = timeout;
            this.keys = keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wait() {
            boolean ret = false;
            Lock lock = JvmMultiNotifier.this.getLock();
            JvmMultiNotifier jvmMultiNotifier = JvmMultiNotifier.this;
            lock.lock();
            try {
                long passed;
                boolean bl = false;
                while ((passed = jvmMultiNotifier.time() - this.start) < this.timeout) {
                    if (jvmMultiNotifier.checkAnyConditionsMet(this.keys)) {
                        ret = true;
                        break;
                    }
                    if (jvmMultiNotifier.getCondition().await(this.timeout - passed, TimeUnit.MILLISECONDS)) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Lock lock = JvmMultiNotifier.this.getLock();
            JvmMultiNotifier jvmMultiNotifier = JvmMultiNotifier.this;
            lock.lock();
            try {
                boolean bl = false;
                jvmMultiNotifier.changeCounters(this.keys, -1);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

