/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy;

import io.mockk.proxy.MockKDispatcher;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKProxyAdviceId;
import io.mockk.proxy.MockKProxyDispatcher;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class MockKStaticProxyAdvice
extends MockKProxyDispatcher {
    public MockKStaticProxyAdvice(Map<Object, MockKInvocationHandler> handlers) {
        super(handlers);
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enterStatic(@MockKProxyAdviceId long id, @Advice.Origin Method method, @Advice.AllArguments Object[] arguments) throws Throwable {
        Class<?> self = method.getDeclaringClass();
        MockKDispatcher dispatcher = MockKDispatcher.get((long)id, self);
        if (dispatcher == null) {
            return null;
        }
        return dispatcher.handle(self, method, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }
}

