/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy;

import io.mockk.agent.MockKAgentException;
import io.mockk.agent.MockKAgentLogger;
import io.mockk.proxy.MockKInstrumentation;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKProxyInterceptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class MockKProxyMaker {
    public static final MockKProxyMaker INSTANCE = new MockKProxyMaker();
    private static final Object BOOTSTRAP_MONITOR = new Object();
    private final ByteBuddy byteBuddy;
    public static MockKAgentLogger log = MockKAgentLogger.NO_OP;
    private final ObjenesisStd objenesis;
    private final TypeCache<CacheKey> proxyClassCache;
    private final TypeCache<CacheKey> instanceProxyClassCache;
    private final Map<Class<?>, ObjectInstantiator<?>> instantiators = Collections.synchronizedMap(new WeakHashMap());
    private static final Set<Class<?>> EXCLUDES = new HashSet<Class>(Arrays.asList(Class.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));

    public MockKProxyMaker() {
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.objenesis = new ObjenesisStd(true);
        this.proxyClassCache = new TypeCache(TypeCache.Sort.SOFT);
        this.instanceProxyClassCache = new TypeCache(TypeCache.Sort.SOFT);
    }

    public <T> T instance(Class<T> cls) {
        if (Modifier.isFinal(cls.getModifiers())) {
            return this.newEmptyInstance(cls);
        }
        try {
            T instance = this.instantiateViaProxy(cls);
            if (instance != null) {
                return instance;
            }
        }
        catch (Exception ex) {
            log.trace(ex, "Failed to instantiate via proxy " + cls + ". Doing just instantiation");
        }
        return this.newEmptyInstance(cls);
    }

    private <T> T instantiateViaProxy(final Class<T> cls) {
        log.trace("Instantiating " + cls + " via subclass proxy");
        final ClassLoader classLoader = cls.getClassLoader();
        Object monitor = classLoader == null ? BOOTSTRAP_MONITOR : classLoader;
        Class proxyCls = this.instanceProxyClassCache.findOrInsert(classLoader, (Object)new CacheKey(cls, new Class[0]), new Callable<Class<?>>(){

            @Override
            public Class<?> call() {
                return MockKProxyMaker.this.byteBuddy.subclass(cls).make().load(classLoader).getLoaded();
            }
        }, monitor);
        return cls.cast(this.newEmptyInstance(proxyCls));
    }

    public <T> T proxy(Class<T> clazz, Class<?>[] interfaces, MockKInvocationHandler handler, boolean useDefaultConstructor, Object instance) {
        Class<Object> proxyClass;
        boolean transformed;
        boolean bl = transformed = this.canInject(clazz) && MockKInstrumentation.INSTANCE.inject(this.getAllSuperclasses(clazz));
        if (!Modifier.isFinal(clazz.getModifiers())) {
            log.trace("Building subclass proxy for " + clazz + " with additional interfaces " + Arrays.asList(interfaces));
            proxyClass = this.subclass(clazz, interfaces);
            if (!transformed) {
                this.warnOnFinalMethods(clazz);
            }
        } else {
            if (!transformed) {
                if (clazz.isPrimitive()) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is a primitive");
                }
                if (clazz.isArray()) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is an array");
                }
                if (!this.canInject(clazz)) {
                    throw new MockKAgentException("Failed to create proxy for " + clazz + ".\n" + clazz + " is one of excluded classes");
                }
                throw new MockKAgentException("Failed to create proxy for " + clazz + ".\nInstrumentation is not available and class is final.\nAdd -javaagent option to enabled MockK Java Agent at JVM startup");
            }
            if (interfaces.length != 0) {
                throw new MockKAgentException("Failed to create proxy for " + clazz + ".\nMore interfaces requested and class is final.");
            }
            log.trace("Taking instance of " + clazz + " itself because it is final.");
            proxyClass = clazz;
        }
        try {
            if (instance == null) {
                if (useDefaultConstructor) {
                    log.trace("Instantiating proxy for " + clazz + " via default constructor.");
                } else {
                    log.trace("Instantiating proxy for " + clazz + " via objenesis.");
                }
                instance = clazz.cast(useDefaultConstructor ? proxyClass.newInstance() : this.newEmptyInstance(proxyClass));
            }
            MockKInstrumentation.INSTANCE.hook(instance, handler);
            return clazz.cast(instance);
        }
        catch (Exception e) {
            throw new MockKAgentException("Instantiation exception", e);
        }
    }

    public void unproxy(Object instance) {
        MockKInstrumentation.INSTANCE.unhook(instance);
    }

    private <T> Class<?> subclass(final Class<T> clazz, final Class<?>[] interfaces) {
        CacheKey key = new CacheKey(clazz, interfaces);
        ClassLoader classLoader = clazz.getClassLoader();
        Object monitor = classLoader == null ? BOOTSTRAP_MONITOR : classLoader;
        return this.proxyClassCache.findOrInsert(classLoader, (Object)key, new Callable<Class<?>>(){

            @Override
            public Class<?> call() {
                ClassLoader classLoader = new MultipleParentClassLoader.Builder().append(new Class[]{clazz}).append(interfaces).append(new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).append(new Class[]{MockKProxyInterceptor.class}).build(MockKProxyInterceptor.class.getClassLoader());
                return MockKProxyMaker.this.byteBuddy.subclass(clazz).implement((Type[])interfaces).method((ElementMatcher)MockKProxyMaker.any()).intercept((Implementation)MethodDelegation.to(MockKProxyInterceptor.class)).make().load(classLoader).getLoaded();
            }
        }, monitor);
    }

    private <T> boolean canInject(Class<T> clazz) {
        return !EXCLUDES.contains(clazz);
    }

    private void warnOnFinalMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null && !clazz.getName().equals(Object.class.getName())) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            clazz = clazz.getSuperclass();
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            log.debug("It is impossible to intercept calls to " + method + " for " + method.getDeclaringClass() + " because it is final");
        }
    }

    private <T> T newEmptyInstance(Class<T> clazz) {
        ObjectInstantiator inst;
        log.trace("Creating new empty instance of " + clazz);
        if (!Modifier.isFinal(clazz.getModifiers())) {
            clazz = this.subclass(clazz, new Class[0]);
        }
        if ((inst = this.instantiators.get(clazz)) == null) {
            inst = this.objenesis.getInstantiatorOf(clazz);
            this.instantiators.put(clazz, inst);
        }
        return (T)clazz.cast(inst.newInstance());
    }

    public void staticProxy(Class<?> clazz, MockKInvocationHandler handler) {
        log.debug("Injecting handler to " + clazz + " for static methods");
        ArrayList lst = new ArrayList();
        lst.add(clazz);
        boolean transformed = MockKInstrumentation.INSTANCE.inject(lst);
        if (!transformed) {
            throw new MockKAgentException("Failed to create static proxy for " + clazz + ".\nTry running VM with MockK Java Agent\ni.e. with -javaagent:mockk-agent.jar option.");
        }
        MockKInstrumentation.INSTANCE.hookStatic(clazz, handler);
    }

    public void staticUnProxy(Class<?> clazz) {
        MockKInstrumentation.INSTANCE.unhookStatic(clazz);
    }

    private static ElementMatcher.Junction<MethodDescription> any() {
        return ElementMatchers.any();
    }

    private List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        HashSet result = new HashSet();
        while (clazz != null) {
            result.add(clazz);
            this.addInterfaces(result, clazz);
            clazz = clazz.getSuperclass();
        }
        return new ArrayList(result);
    }

    private void addInterfaces(Set<Class<?>> result, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            result.add(intf);
            this.addInterfaces(result, intf.getSuperclass());
        }
    }

    private static final class CacheKey {
        private final Class<?> clazz;
        private final Set<Class<?>> interfaces;

        CacheKey(Class<?> clazz, Class<?>[] interfaces) {
            this.clazz = clazz;
            this.interfaces = new HashSet(Arrays.asList(interfaces));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.clazz.equals(cacheKey.clazz) && this.interfaces.equals(cacheKey.interfaces);
        }

        public int hashCode() {
            return 31 * this.clazz.hashCode() + this.interfaces.hashCode();
        }
    }
}

