/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy;

import io.mockk.proxy.MockKCallProxy;
import io.mockk.proxy.MockKDispatcher;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKSelfCall;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;

public class MockKProxyDispatcher
extends MockKDispatcher {
    private static final Random RNG = new Random();
    private final long id = RNG.nextLong();
    private final Map<Object, MockKInvocationHandler> handlers;

    public MockKProxyDispatcher(Map<Object, MockKInvocationHandler> handlers) {
        this.handlers = handlers;
    }

    public long getId() {
        return this.id;
    }

    public Callable<?> handle(Object self, Method method, Object[] arguments) throws Exception {
        MockKInvocationHandler handler = this.handlers.get(self);
        if (handler == null) {
            return null;
        }
        if (MockKSelfCall.isSelf(self, method)) {
            return null;
        }
        return new MockKCallProxy(handler, self, method, arguments);
    }
}

