/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy;

import io.mockk.agent.MockKAgentLogger;
import io.mockk.proxy.MockKDispatcher;
import io.mockk.proxy.MockKHashMapStaticProxyAdvice;
import io.mockk.proxy.MockKInstrumentationLoader;
import io.mockk.proxy.MockKInvocationHandler;
import io.mockk.proxy.MockKProxyAdvice;
import io.mockk.proxy.MockKProxyAdviceId;
import io.mockk.proxy.MockKProxyDispatcher;
import io.mockk.proxy.MockKStaticProxyAdvice;
import io.mockk.proxy.MockKWeakMap;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MockKInstrumentation
implements ClassFileTransformer {
    public static MockKAgentLogger log = MockKAgentLogger.NO_OP;
    public static MockKInstrumentation INSTANCE;
    private Map<Object, MockKInvocationHandler> handlers;
    private Map<Object, MockKInvocationHandler> staticHandlers;
    private volatile Instrumentation instrumentation;
    private MockKProxyAdvice advice;
    private MockKStaticProxyAdvice staticAdvice;
    private MockKHashMapStaticProxyAdvice staticHashMapAdvice;
    private final Set<Class<?>> classesToTransform = Collections.synchronizedSet(new HashSet());
    private ByteBuddy byteBuddy;

    public static void init() {
        INSTANCE = new MockKInstrumentation();
    }

    MockKInstrumentation() {
        this.instrumentation = ByteBuddyAgent.install();
        if (this.instrumentation != null) {
            log.trace("Byte buddy agent installed");
            if (MockKInstrumentationLoader.LOADER.loadBootJar(this.instrumentation)) {
                log.trace("Installing MockKInstrumentation transformer");
                this.instrumentation.addTransformer(this, true);
            } else {
                log.trace("Can't inject boot jar.");
                this.instrumentation = null;
            }
        } else {
            log.trace("Can't install ByteBuddy agent.\nTry running VM with MockK Java Agent\ni.e. with -javaagent:mockk-agent.jar option.");
        }
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED).with((Implementation.Context.Factory)Implementation.Context.Disabled.Factory.INSTANCE);
        if (this.instrumentation != null) {
            class AdviceBuilder {
                AdviceBuilder() {
                }

                void build() {
                    MockKInstrumentation.this.handlers = (Map)new MockKWeakMap();
                    MockKInstrumentation.this.advice = new MockKProxyAdvice(MockKInstrumentation.this.handlers);
                    MockKInstrumentation.this.staticHandlers = (Map)new MockKWeakMap();
                    MockKInstrumentation.this.staticAdvice = new MockKStaticProxyAdvice(MockKInstrumentation.this.staticHandlers);
                    MockKInstrumentation.this.staticHashMapAdvice = new MockKHashMapStaticProxyAdvice(MockKInstrumentation.this.staticHandlers);
                    MockKDispatcher.set((long)MockKInstrumentation.this.advice.getId(), (MockKDispatcher)MockKInstrumentation.this.advice);
                    MockKDispatcher.set((long)MockKInstrumentation.this.staticAdvice.getId(), (MockKDispatcher)MockKInstrumentation.this.staticAdvice);
                    MockKDispatcher.set((long)MockKInstrumentation.this.staticHashMapAdvice.getId(), (MockKDispatcher)MockKInstrumentation.this.staticHashMapAdvice);
                }
            }
            new AdviceBuilder().build();
        } else {
            this.handlers = Collections.synchronizedMap(new IdentityHashMap());
            this.staticHandlers = Collections.synchronizedMap(new IdentityHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inject(List<Class<?>> classes) {
        if (this.instrumentation == null) {
            return false;
        }
        Set<Class<?>> set = this.classesToTransform;
        synchronized (set) {
            classes.removeAll(this.classesToTransform);
            if (classes.isEmpty()) {
                return true;
            }
            log.trace("Injecting handler to " + classes);
            this.classesToTransform.addAll(classes);
        }
        Class[] cls = classes.toArray(new Class[classes.size()]);
        try {
            this.instrumentation.retransformClasses(cls);
            log.trace("Injected OK");
            return true;
        }
        catch (UnmodifiableClassException e) {
            return false;
        }
    }

    public void enable() {
        this.instrumentation = ByteBuddyAgent.getInstrumentation();
    }

    public void disable() {
        this.instrumentation = null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.classesToTransform.contains(classBeingRedefined)) {
            return null;
        }
        try {
            DynamicType.Unloaded unloaded = this.byteBuddy.redefine(classBeingRedefined, ClassFileLocator.Simple.of((String)classBeingRedefined.getName(), (byte[])classfileBuffer)).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockKProxyAdviceId.class, (Object)this.advice.getId()).to(MockKProxyAdvice.class).on((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDefaultFinalizer())))).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockKProxyAdviceId.class, (Object)this.staticProxyAdviceId(className)).to(this.staticProxyAdvice(className)).on((ElementMatcher)ElementMatchers.isStatic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isTypeInitializer())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isConstructor())))).make();
            return unloaded.getBytes();
        }
        catch (Throwable e) {
            log.warn(e, "Failed to transform class");
            return null;
        }
    }

    private long staticProxyAdviceId(String className) {
        return className.equals("java/util/HashMap") ? this.staticHashMapAdvice.getId() : this.staticAdvice.getId();
    }

    private Class<? extends MockKProxyDispatcher> staticProxyAdvice(String className) {
        return className.equals("java/util/HashMap") ? MockKHashMapStaticProxyAdvice.class : MockKStaticProxyAdvice.class;
    }

    private static ElementMatcher.Junction<MethodDescription> isPackagePrivateJavaMethods() {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.nameStartsWith((String)"java.")).and((ElementMatcher)ElementMatchers.isPackagePrivate());
    }

    public <T> void hook(T instance, MockKInvocationHandler handler) {
        this.handlers.put(instance, handler);
    }

    public <T> void unhook(T instance) {
        this.handlers.remove(instance);
    }

    public void hookStatic(Class<?> clazz, MockKInvocationHandler handler) {
        this.staticHandlers.put(clazz, handler);
    }

    public void unhookStatic(Class<?> clazz) {
        this.staticHandlers.remove(clazz);
    }

    public MockKInvocationHandler getHook(Object self) {
        return this.handlers.get(self);
    }
}

