/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.ObservationView;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.stream.Collectors;

class SimpleObservation
implements Observation {
    private final ObservationRegistry registry;
    private final Observation.Context context;
    @Nullable
    private ObservationConvention convention;
    private final Deque<ObservationHandler> handlers;
    private final Collection<ObservationFilter> filters;

    SimpleObservation(@Nullable String name, ObservationRegistry registry, Observation.Context context) {
        this.registry = registry;
        this.context = context;
        this.context.setName(name);
        this.convention = SimpleObservation.getConventionFromConfig(registry, context);
        this.handlers = SimpleObservation.getHandlersFromConfig(registry, context);
        this.filters = registry.observationConfig().getObservationFilters();
    }

    SimpleObservation(ObservationConvention<? extends Observation.Context> convention, ObservationRegistry registry, Observation.Context context) {
        this.registry = registry;
        this.context = context;
        this.handlers = SimpleObservation.getHandlersFromConfig(registry, context);
        this.filters = registry.observationConfig().getObservationFilters();
        if (!convention.supportsContext(context)) {
            throw new IllegalStateException("Convention [" + convention + "] doesn't support context [" + context + "]");
        }
        this.convention = convention;
    }

    @Nullable
    private static ObservationConvention getConventionFromConfig(ObservationRegistry registry, Observation.Context context) {
        return registry.observationConfig().getObservationConventions().stream().filter(convention -> convention.supportsContext(context)).findFirst().orElse(null);
    }

    private static Deque<ObservationHandler> getHandlersFromConfig(ObservationRegistry registry, Observation.Context context) {
        return registry.observationConfig().getObservationHandlers().stream().filter(handler -> handler.supportsContext(context)).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Override
    public Observation contextualName(@Nullable String contextualName) {
        this.context.setContextualName(contextualName);
        return this;
    }

    @Override
    public Observation parentObservation(@Nullable Observation parentObservation) {
        this.context.setParentObservation(parentObservation);
        return this;
    }

    @Override
    public Observation lowCardinalityKeyValue(KeyValue keyValue) {
        this.context.addLowCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation highCardinalityKeyValue(KeyValue keyValue) {
        this.context.addHighCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation observationConvention(ObservationConvention<?> convention) {
        if (convention.supportsContext(this.context)) {
            this.convention = convention;
        }
        return this;
    }

    @Override
    public Observation error(Throwable error) {
        this.context.setError(error);
        this.notifyOnError();
        return this;
    }

    @Override
    public Observation event(Observation.Event event) {
        this.notifyOnEvent(event);
        return this;
    }

    @Override
    public Observation start() {
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            String newName = this.convention.getName();
            if (StringUtils.isNotBlank((String)newName)) {
                this.context.setName(newName);
            }
        }
        this.notifyOnObservationStarted();
        return this;
    }

    @Override
    public Observation.Context getContext() {
        return this.context;
    }

    @Override
    public void stop() {
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            String newContextualName = this.convention.getContextualName(this.context);
            if (StringUtils.isNotBlank((String)newContextualName)) {
                this.context.setContextualName(newContextualName);
            }
        }
        Observation.Context modifiedContext = this.context;
        for (ObservationFilter filter : this.filters) {
            modifiedContext = filter.map(modifiedContext);
        }
        this.notifyOnObservationStopped(modifiedContext);
    }

    @Override
    public Observation.Scope openScope() {
        SimpleScope scope = new SimpleScope(this.registry, this);
        this.notifyOnScopeOpened();
        return scope;
    }

    public String toString() {
        return "{name=" + this.context.getName() + "(" + this.context.getContextualName() + "), error=" + this.context.getError() + ", context=" + this.context + '}';
    }

    private void notifyOnObservationStarted() {
        this.handlers.forEach(handler -> handler.onStart(this.context));
    }

    private void notifyOnError() {
        this.handlers.forEach(handler -> handler.onError(this.context));
    }

    private void notifyOnEvent(Observation.Event event) {
        this.handlers.forEach(handler -> handler.onEvent(event, this.context));
    }

    private void notifyOnScopeOpened() {
        this.handlers.forEach(handler -> handler.onScopeOpened(this.context));
    }

    private void notifyOnScopeClosed() {
        this.handlers.descendingIterator().forEachRemaining(handler -> handler.onScopeClosed(this.context));
    }

    private void notifyOnObservationStopped(Observation.Context context) {
        this.handlers.descendingIterator().forEachRemaining(handler -> handler.onStop(context));
    }

    static class SimpleScope
    implements Observation.Scope {
        private final ObservationRegistry registry;
        private final SimpleObservation currentObservation;
        @Nullable
        private final Observation.Scope previousObservationScope;
        @Nullable
        private final ObservationView previousParentObservationView;

        SimpleScope(ObservationRegistry registry, SimpleObservation current) {
            this.registry = registry;
            this.currentObservation = current;
            this.previousObservationScope = registry.getCurrentObservationScope();
            this.previousParentObservationView = current.context.getParentObservation();
            if (this.previousObservationScope != null) {
                current.context.setParentObservation(this.previousObservationScope.getCurrentObservation());
            }
            this.registry.setCurrentObservationScope(this);
        }

        @Override
        public Observation getCurrentObservation() {
            return this.currentObservation;
        }

        @Override
        public void close() {
            this.registry.setCurrentObservationScope(this.previousObservationScope);
            this.currentObservation.notifyOnScopeClosed();
            this.currentObservation.context.setParentObservation(this.previousParentObservationView);
        }
    }
}

