/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import io.micrometer.core.instrument.util.MathUtils;
import java.util.AbstractList;
import java.util.List;

public abstract class AbstractPartition<T>
extends AbstractList<List<T>> {
    private final List<T> list;
    private final int partitionSize;
    private final int partitionCount;

    protected AbstractPartition(List<T> list, int partitionSize) {
        this.list = list;
        this.partitionSize = partitionSize;
        this.partitionCount = MathUtils.divideWithCeilingRoundingMode(list.size(), partitionSize);
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.partitionSize;
        int end = Math.min(start + this.partitionSize, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return this.partitionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

