/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import io.lettuce.core.LettuceStrings;
import java.util.Collection;

public class LettuceAssert {
    private LettuceAssert() {
    }

    public static void notEmpty(String string, String message) {
        if (LettuceStrings.isEmpty(string)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(int[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Collection<?> c, String message) {
        if (c != null) {
            for (Object element : c) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void isTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

