/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.KeyValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeyValueListOutput<K, V>
extends CommandOutput<K, V, List<KeyValue<K, V>>>
implements StreamingOutput<KeyValue<K, V>> {
    private StreamingOutput.Subscriber<KeyValue<K, V>> subscriber;
    private Iterable<K> keys;
    private Iterator<K> keyIterator;

    public KeyValueListOutput(RedisCodec<K, V> codec, Iterable<K> keys) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<KeyValue<K, V>>)ListSubscriber.of((List)this.output));
        this.keys = keys;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.keyIterator == null) {
            this.keyIterator = this.keys.iterator();
        }
        this.subscriber.onNext(KeyValue.fromNullable(this.keyIterator.next(), bytes == null ? null : (Object)this.codec.decodeValue(bytes)));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<KeyValue<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<KeyValue<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

