/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class LettuceFutures {
    private LettuceFutures() {
    }

    public static boolean awaitAll(Duration timeout, Future<?> ... futures) {
        return LettuceFutures.awaitAll(timeout.toNanos(), TimeUnit.NANOSECONDS, futures);
    }

    public static boolean awaitAll(long timeout, TimeUnit unit, Future<?> ... futures) {
        return LettuceFutures.translateException(() -> {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (Future f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            return true;
        }, () -> false);
    }

    public static <T> T awaitOrCancel(RedisFuture<T> cmd, long timeout, TimeUnit unit) {
        return (T)LettuceFutures.translateException(() -> {
            if (!cmd.await(timeout, unit)) {
                cmd.cancel(true);
                throw new RedisCommandTimeoutException();
            }
            return cmd.get();
        }, () -> null);
    }

    protected static <T> T translateException(Callable<T> callable, Supplier<T> otherwiseTimeout) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (TimeoutException e) {
            return otherwiseTimeout.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw new RedisCommandExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw new RedisCommandExecutionException(e);
        }
    }
}

