/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyHttpHandlerState;
import io.ktor.server.netty.cio.NettyHttpResponsePipeline;
import io.ktor.server.netty.cio.RequestBodyHandler;
import io.ktor.server.netty.http1.NettyHttp1ApplicationCall;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020)H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020)H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/ktor/server/netty/http1/NettyHttp1Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "runningLimit", "", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;I)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handlerJob", "Lkotlinx/coroutines/CompletableDeferred;", "", "responseWriter", "Lio/ktor/server/netty/cio/NettyHttpResponsePipeline;", "skipEmpty", "", "state", "Lio/ktor/server/netty/NettyHttpHandlerState;", "callReadIfNeeded", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "channelActive", "channelInactive", "channelRead", "message", "", "channelReadComplete", "exceptionCaught", "cause", "", "handleRequest", "Lio/netty/handler/codec/http/HttpRequest;", "prepareCallFromRequest", "Lio/ktor/server/netty/http1/NettyHttp1ApplicationCall;", "prepareRequestContentChannel", "Lio/ktor/utils/io/ByteReadChannel;", "ktor-server-netty"})
public final class NettyHttp1Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    private final int runningLimit;
    @NotNull
    private final CompletableDeferred handlerJob;
    private boolean skipEmpty;
    private NettyHttpResponsePipeline responseWriter;
    @NotNull
    private final NettyHttpHandlerState state;

    public NettyHttp1Handler(@NotNull EnginePipeline enginePipeline, @NotNull ApplicationEngineEnvironment environment, @NotNull EventExecutorGroup callEventGroup2, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, int runningLimit) {
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup2, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup2;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.runningLimit = runningLimit;
        this.handlerJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.state = new NettyHttpHandlerState(this.runningLimit);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    public void channelActive(@NotNull ChannelHandlerContext context) {
        ChannelPipeline channelPipeline;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.responseWriter = new NettyHttpResponsePipeline(context, this.state, this.getCoroutineContext());
        context.channel().config().setAutoRead(false);
        context.channel().read();
        ChannelPipeline $this$channelActive_u24lambda_u240 = channelPipeline = context.pipeline();
        boolean bl = false;
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new RequestBodyHandler(context)};
        $this$channelActive_u24lambda_u240.addLast(channelHandlerArray);
        channelHandlerArray = new ChannelHandler[]{new NettyApplicationCallHandler(this.userContext, this.enginePipeline)};
        $this$channelActive_u24lambda_u240.addLast(this.callEventGroup, channelHandlerArray);
        context.fireChannelActive();
    }

    public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message instanceof LastHttpContent) {
            NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 0, 1);
        }
        if (message instanceof HttpRequest) {
            if (!(message instanceof LastHttpContent)) {
                NettyHttpHandlerState.isCurrentRequestFullyRead$FU$internal.compareAndSet(this.state, 1, 0);
            }
            NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 1, 0);
            NettyHttpHandlerState.activeRequests$FU$internal.incrementAndGet(this.state);
            this.handleRequest(context, (HttpRequest)message);
            this.callReadIfNeeded(context);
        } else if (message instanceof LastHttpContent && !((LastHttpContent)message).content().isReadable() && this.skipEmpty) {
            this.skipEmpty = false;
            ((LastHttpContent)message).release();
            this.callReadIfNeeded(context);
        } else {
            context.fireChannelRead(message);
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.pipeline().remove(NettyApplicationCallHandler.class);
        context.fireChannelInactive();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Throwable throwable = cause;
        if (throwable instanceof IOException) {
            ApplicationKt.getLog((Application)this.environment.getApplication()).debug("I/O operation failed", cause);
            Job.DefaultImpls.cancel$default((Job)((Job)this.handlerJob), null, (int)1, null);
            context.close();
        } else if (throwable instanceof ReadTimeoutException) {
            context.fireExceptionCaught(cause);
        } else {
            this.handlerJob.completeExceptionally(cause);
            context.close();
        }
    }

    public void channelReadComplete(@Nullable ChannelHandlerContext context) {
        NettyHttpHandlerState.isChannelReadCompleted$FU$internal.compareAndSet(this.state, 0, 1);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.flushIfNeeded$ktor_server_netty();
        super.channelReadComplete(context);
    }

    private final void handleRequest(ChannelHandlerContext context, HttpRequest message) {
        NettyHttp1ApplicationCall call = this.prepareCallFromRequest(context, message);
        context.fireChannelRead((Object)call);
        NettyHttpResponsePipeline nettyHttpResponsePipeline = this.responseWriter;
        if (nettyHttpResponsePipeline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseWriter");
            nettyHttpResponsePipeline = null;
        }
        nettyHttpResponsePipeline.processResponse$ktor_server_netty(call);
    }

    private final NettyHttp1ApplicationCall prepareCallFromRequest(ChannelHandlerContext context, HttpRequest message) {
        ByteReadChannel byteReadChannel;
        if (message instanceof LastHttpContent && !((LastHttpContent)message).content().isReadable()) {
            byteReadChannel = null;
        } else if (message.method() == HttpMethod.GET && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)message)) && !HttpUtil.isTransferEncodingChunked((HttpMessage)((HttpMessage)message))) {
            this.skipEmpty = true;
            byteReadChannel = null;
        } else {
            byteReadChannel = this.prepareRequestContentChannel(context, message);
        }
        ByteReadChannel requestBodyChannel = byteReadChannel;
        return new NettyHttp1ApplicationCall(this.environment.getApplication(), context, message, requestBodyChannel, this.engineContext, this.userContext);
    }

    private final ByteReadChannel prepareRequestContentChannel(ChannelHandlerContext context, HttpRequest message) {
        RequestBodyHandler bodyHandler = (RequestBodyHandler)context.pipeline().get(RequestBodyHandler.class);
        ByteReadChannel result = bodyHandler.newChannel();
        if (message instanceof HttpContent) {
            bodyHandler.channelRead(context, message);
        }
        return result;
    }

    private final void callReadIfNeeded(ChannelHandlerContext context) {
        if (this.state.activeRequests$internal < (long)this.runningLimit) {
            context.read();
            this.state.skippedRead$internal = 0;
        } else {
            this.state.skippedRead$internal = 1;
        }
    }
}

