/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestCookies;
import io.ktor.server.netty.NettyMultiPartData;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H$J\b\u0010+\u001a\u00020\nH\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b\"\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lio/ktor/server/netty/NettyApplicationRequest;", "Lio/ktor/server/engine/BaseApplicationRequest;", "Lkotlinx/coroutines/CoroutineScope;", "call", "Lio/ktor/server/application/ApplicationCall;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "context", "Lio/netty/channel/ChannelHandlerContext;", "requestBodyChannel", "Lio/ktor/utils/io/ByteReadChannel;", "uri", "", "keepAlive", "", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/ktor/utils/io/ByteReadChannel;Ljava/lang/String;Z)V", "contentMultipart", "Lkotlin/Lazy;", "Lio/ktor/server/netty/NettyMultiPartData;", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getKeepAlive$ktor_server_netty", "()Z", "queryParameters", "Lio/ktor/http/Parameters;", "getQueryParameters", "()Lio/ktor/http/Parameters;", "rawQueryParameters", "getRawQueryParameters", "rawQueryParameters$delegate", "Lkotlin/Lazy;", "getUri", "()Ljava/lang/String;", "close", "", "newDecoder", "Lio/netty/handler/codec/http/multipart/HttpPostMultipartRequestDecoder;", "receiveChannel", "ktor-server-netty"})
public abstract class NettyApplicationRequest
extends BaseApplicationRequest
implements CoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final ByteReadChannel requestBodyChannel;
    @NotNull
    private final String uri;
    private final boolean keepAlive;
    @NotNull
    private final Parameters queryParameters;
    @NotNull
    private final Lazy rawQueryParameters$delegate;
    @NotNull
    private final RequestCookies cookies;
    @NotNull
    private final Lazy<NettyMultiPartData> contentMultipart;

    public NettyApplicationRequest(@NotNull ApplicationCall call, @NotNull CoroutineContext coroutineContext, @NotNull ChannelHandlerContext context, @NotNull ByteReadChannel requestBodyChannel, @NotNull String uri, boolean keepAlive) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)requestBodyChannel, (String)"requestBodyChannel");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        super(call);
        this.coroutineContext = coroutineContext;
        this.context = context;
        this.requestBodyChannel = requestBodyChannel;
        this.uri = uri;
        this.keepAlive = keepAlive;
        this.queryParameters = new Parameters(this){
            @NotNull
            private final QueryStringDecoder decoder;
            {
                this.decoder = new QueryStringDecoder($receiver.getUri(), HttpConstants.DEFAULT_CHARSET, true, 1024, true);
            }

            public boolean getCaseInsensitiveName() {
                return true;
            }

            @Nullable
            public List<String> getAll(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return (List)this.decoder.parameters().get(name);
            }

            @NotNull
            public Set<String> names() {
                return this.decoder.parameters().keySet();
            }

            @NotNull
            public Set<Map.Entry<String, List<String>>> entries() {
                return this.decoder.parameters().entrySet();
            }

            public boolean isEmpty() {
                return this.decoder.parameters().isEmpty();
            }

            public boolean contains(@NotNull String name) {
                return Parameters.DefaultImpls.contains((Parameters)this, (String)name);
            }

            public boolean contains(@NotNull String name, @NotNull String value) {
                return Parameters.DefaultImpls.contains((Parameters)this, (String)name, (String)value);
            }

            public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
                Parameters.DefaultImpls.forEach((Parameters)this, body);
            }

            @Nullable
            public String get(@NotNull String name) {
                return Parameters.DefaultImpls.get((Parameters)this, (String)name);
            }
        };
        this.rawQueryParameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Parameters>(this){
            final /* synthetic */ NettyApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Parameters invoke() {
                Integer n = StringsKt.indexOf$default((CharSequence)this.this$0.getUri(), (char)'?', (int)0, (boolean)false, (int)6, null);
                int it = ((Number)n).intValue();
                boolean bl = false;
                Integer n2 = it != -1 ? n : null;
                if (n2 == null) {
                    return Parameters.Companion.getEmpty();
                }
                int queryStartIndex = n2;
                return QueryKt.parseQueryString$default((String)this.this$0.getUri(), (int)(queryStartIndex + 1), (int)0, (boolean)false, (int)4, null);
            }
        }));
        this.cookies = new NettyApplicationRequestCookies((ApplicationRequest)this);
        this.contentMultipart = LazyKt.lazy((Function0)((Function0)new Function0<NettyMultiPartData>(this){
            final /* synthetic */ NettyApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NettyMultiPartData invoke() {
                if (!ApplicationRequestPropertiesKt.isMultipart((ApplicationRequest)((ApplicationRequest)this.this$0))) {
                    throw new IOException("The request content is not multipart encoded");
                }
                HttpPostMultipartRequestDecoder decoder = this.this$0.newDecoder();
                ByteBufAllocator byteBufAllocator = this.this$0.getContext().alloc();
                Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"context.alloc()");
                return new NettyMultiPartData(decoder, byteBufAllocator, NettyApplicationRequest.access$getRequestBodyChannel$p(this.this$0));
            }
        }));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final ChannelHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final String getUri() {
        return this.uri;
    }

    public final boolean getKeepAlive$ktor_server_netty() {
        return this.keepAlive;
    }

    @NotNull
    public final Parameters getQueryParameters() {
        return this.queryParameters;
    }

    @NotNull
    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    @NotNull
    public ByteReadChannel receiveChannel() {
        return this.requestBodyChannel;
    }

    @NotNull
    protected abstract HttpPostMultipartRequestDecoder newDecoder();

    public final void close() {
        if (this.contentMultipart.isInitialized()) {
            ((NettyMultiPartData)this.contentMultipart.getValue()).destroy$ktor_server_netty();
        }
    }

    public static final /* synthetic */ ByteReadChannel access$getRequestBodyChannel$p(NettyApplicationRequest $this) {
        return $this.requestBodyChannel;
    }
}

