/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.HoconApplicationConfig;
import io.ktor.server.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.CommandLineKt;
import io.ktor.server.engine.ConfigKeys;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.CharsetKt;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001b\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\u001f\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\u0010\t\u001aB\u0010\n\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a8\u0006\u0011"}, d2={"buildApplicationConfig", "Lio/ktor/server/config/ApplicationConfig;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "configurePlatformProperties", "", "Lio/ktor/server/engine/ApplicationEngineEnvironmentBuilder;", "(Lio/ktor/server/engine/ApplicationEngineEnvironmentBuilder;[Ljava/lang/String;)V", "configureSSLConnectors", "host", "sslPort", "sslKeyStorePath", "sslKeyStorePassword", "sslPrivateKeyPassword", "sslKeyAlias", "ktor-server-host-common"})
public final class EnvironmentUtilsJvmKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationConfig buildApplicationConfig(@NotNull String[] args) {
        File file;
        Config argConfig;
        File configFile;
        block13: {
            block12: {
                File file2;
                void $this$mapKeysTo$iv$iv;
                Map argumentsPairs;
                Map.Entry it;
                Map.Entry element$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                String[] $this$mapNotNull$iv = args;
                boolean $i$f$mapNotNull = false;
                String[] stringArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    Pair<String, String> it$iv$iv;
                    element$iv$iv = element$iv$iv$iv;
                    boolean bl = false;
                    it = element$iv$iv;
                    boolean bl2 = false;
                    if (CommandLineKt.splitPair((String)((Object)it), '=') == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Map $this$filterKeys$iv = argumentsPairs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                boolean $i$f$filterKeys = false;
                Map result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                    String it2 = (String)entry$iv.getKey();
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)"-P:", (boolean)false, (int)2, null)) continue;
                    ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map $this$mapKeys$iv = result$iv;
                boolean $i$f$mapKeys = false;
                result$iv = $this$mapKeys$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    void it3;
                    element$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv2;
                    boolean bl = false;
                    it = (Map.Entry)element$iv$iv$iv;
                    String string = StringsKt.removePrefix((String)((String)it3.getKey()), (CharSequence)"-P:");
                    Map map2 = map;
                    boolean bl4 = false;
                    Object v = it$iv$iv.getValue();
                    map2.put(string, v);
                }
                Map commandLineProperties = destination$iv$iv2;
                String string = (String)argumentsPairs.get("-config");
                if (string != null) {
                    String it4 = string;
                    boolean bl = false;
                    file2 = new File(it4);
                } else {
                    file2 = null;
                }
                configFile = file2;
                argConfig = ConfigFactory.parseMap((Map)commandLineProperties, (String)"Command-line options");
                file = configFile;
                if (file == null) break block12;
                File it5 = file;
                boolean bl = false;
                Config config = ConfigFactory.parseFile((File)it5);
                file = config;
                if (config != null) break block13;
            }
            file = ConfigFactory.load();
        }
        File fileConfig = file;
        Config environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback((ConfigMergeable)environmentConfig).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)combinedConfig, (String)"combinedConfig");
        String string = HoconApplicationConfigKt.tryGetString((Config)combinedConfig, (String)ConfigKeys.INSTANCE.getApplicationIdPath());
        if (string == null) {
            string = "Application";
        }
        String applicationId = string;
        Logger logger = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            logger.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            logger.warn("Will attempt to start without loading configuration\u2026");
        }
        ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef((Object)"***", (String)"Content hidden");
        if (combinedConfig.hasPath("ktor")) {
            logger.trace(combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
        } else {
            logger.trace("No configuration provided: neither application.conf nor system properties nor command line options (-config or -P:ktor...=) provided");
        }
        return (ApplicationConfig)new HoconApplicationConfig(combinedConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void configureSSLConnectors(@NotNull ApplicationEngineEnvironmentBuilder $this$configureSSLConnectors, @NotNull String host, @NotNull String sslPort, @Nullable String sslKeyStorePath, @Nullable String sslKeyStorePassword, @Nullable String sslPrivateKeyPassword, @NotNull String sslKeyAlias) {
        void $this$configureSSLConnectors_u24lambda_u2d9;
        void $this$sslConnector$iv;
        void keyStorePassword$iv;
        void keyStore$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$configureSSLConnectors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)sslPort, (String)"sslPort");
        Intrinsics.checkNotNullParameter((Object)sslKeyAlias, (String)"sslKeyAlias");
        if (sslKeyStorePath == null) {
            throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + ConfigKeys.INSTANCE.getHostSslKeyStore() + " config");
        }
        if (sslKeyStorePassword == null) {
            throw new IllegalArgumentException("SSL requires keystore password: use " + ConfigKeys.INSTANCE.getHostSslKeyStorePassword() + " config");
        }
        if (sslPrivateKeyPassword == null) {
            throw new IllegalArgumentException("SSL requires certificate password: use " + ConfigKeys.INSTANCE.getHostSslPrivateKeyPassword() + " config");
        }
        Object file = new File(sslKeyStorePath);
        boolean bl = false;
        File keyStoreFile = ((File)file).exists() || ((File)file).isAbsolute() ? file : new File(".", sslKeyStorePath).getAbsoluteFile();
        Object $this$configureSSLConnectors_u24lambda_u2d8 = file = KeyStore.getInstance("JKS");
        boolean $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = false;
        Closeable closeable = new FileInputStream(keyStoreFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl2 = false;
            ((KeyStore)$this$configureSSLConnectors_u24lambda_u2d8).load(it, CharsetKt.toCharArray((String)sslKeyStorePassword));
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (((KeyStore)$this$configureSSLConnectors_u24lambda_u2d8).getKey(sslKeyAlias, CharsetKt.toCharArray((String)sslPrivateKeyPassword)) == null) {
            boolean $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = false;
            String $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
            throw new IllegalArgumentException($i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32.toString());
        }
        Object keyStore = file;
        file = $this$configureSSLConnectors;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keyStore");
        $this$configureSSLConnectors_u24lambda_u2d8 = keyStore;
        Function0 $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = (Function0)new Function0<char[]>(sslKeyStorePassword){
            final /* synthetic */ String $sslKeyStorePassword;
            {
                this.$sslKeyStorePassword = $sslKeyStorePassword;
                super(0);
            }

            @NotNull
            public final char[] invoke() {
                return CharsetKt.toCharArray((String)this.$sslKeyStorePassword);
            }
        };
        Function0 privateKeyPassword$iv = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
            final /* synthetic */ String $sslPrivateKeyPassword;
            {
                this.$sslPrivateKeyPassword = $sslPrivateKeyPassword;
                super(0);
            }

            @NotNull
            public final char[] invoke() {
                return CharsetKt.toCharArray((String)this.$sslPrivateKeyPassword);
            }
        };
        boolean $i$f$sslConnector = false;
        Object bl2 = object = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
        List<EngineConnectorConfig> list = $this$sslConnector$iv.getConnectors();
        boolean bl3 = false;
        $this$configureSSLConnectors_u24lambda_u2d9.setHost(host);
        $this$configureSSLConnectors_u24lambda_u2d9.setPort(Integer.parseInt(sslPort));
        $this$configureSSLConnectors_u24lambda_u2d9.setKeyStorePath(keyStoreFile);
        list.add((EngineConnectorConfig)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configurePlatformProperties(@NotNull ApplicationEngineEnvironmentBuilder $this$configurePlatformProperties, @NotNull String[] args) {
        ClassLoader classLoader;
        URL uRL;
        String it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$configurePlatformProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it2 = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it2, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argumentsPairs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = (String)argumentsPairs.get("-jar");
        if (string != null) {
            it = string;
            boolean bl = false;
            uRL = StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
        } else {
            uRL = null;
        }
        URL jar = uRL;
        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$configurePlatformProperties;
        URL uRL2 = jar;
        if (uRL2 != null) {
            it = uRL2;
            ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = applicationEngineEnvironmentBuilder;
            boolean bl = false;
            URL[] uRLArray = new URL[]{jar};
            applicationEngineEnvironmentBuilder = applicationEngineEnvironmentBuilder2;
            classLoader = new URLClassLoader(uRLArray, ApplicationEnvironment.class.getClassLoader());
        } else {
            ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
        }
        applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
    }
}

