/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a%\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a/\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\b\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004\u00a8\u0006\u0015"}, d2={"findTrustManager", "Ljavax/net/ssl/X509TrustManager;", "addCertificateChain", "", "Lio/ktor/network/tls/TLSConfigBuilder;", "chain", "", "Ljava/security/cert/X509Certificate;", "key", "Ljava/security/PrivateKey;", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "addKeyStore", "store", "Ljava/security/KeyStore;", "password", "", "alias", "", "addKeyStoreNullablePassword", "takeFrom", "other", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void takeFrom(@NotNull TLSConfigBuilder $this$takeFrom, @NotNull TLSConfigBuilder other) {
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        CollectionsKt.addAll((Collection)$this$takeFrom.getCertificates(), (Iterable)other.getCertificates());
        $this$takeFrom.setRandom(other.getRandom());
        $this$takeFrom.setCipherSuites(other.getCipherSuites());
        $this$takeFrom.setServerName(other.getServerName());
        $this$takeFrom.setTrustManager(other.getTrustManager());
    }

    public static final void addCertificateChain(@NotNull TLSConfigBuilder $this$addCertificateChain, @NotNull X509Certificate[] chain, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$addCertificateChain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Collection)$this$addCertificateChain.getCertificates()).add(new CertificateAndKey(chain, key));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="addKeyStoreNullablePassword")
    public static final void addKeyStoreNullablePassword(@NotNull TLSConfigBuilder $this$addKeyStore, @NotNull KeyStore store, @Nullable char[] password, @Nullable String alias) {
        Object object;
        List managers;
        block12: {
            block11: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$addKeyStore, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)store, (String)"store");
                String string = KeyManagerFactory.getDefaultAlgorithm();
                Intrinsics.checkNotNull((Object)string);
                String keyManagerAlgorithm = string;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
                Intrinsics.checkNotNull((Object)keyManagerFactory);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                keyManagerFactory2.init(store, password);
                KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
                Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"keyManagerFactory.keyManagers");
                Object[] $this$filterIsInstance$iv = keyManagerArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof X509KeyManager)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                managers = (List)destination$iv$iv;
                object = alias;
                if (object == null) break block11;
                String it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                object = list;
                if (list != null) break block12;
            }
            Enumeration<String> enumeration = store.aliases();
            Intrinsics.checkNotNull(enumeration);
            ArrayList<String> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
            object = arrayList;
        }
        Object aliases = object;
        Iterator iterator = aliases.iterator();
        block1: while (iterator.hasNext()) {
            boolean allX509;
            Certificate[] chain;
            String certAlias;
            block10: {
                boolean bl;
                certAlias = (String)iterator.next();
                Certificate[] certificateArray = chain = store.getCertificateChain(certAlias);
                if (chain == null) {
                    boolean $i$a$-checkNotNull-TLSConfigBuilderKt$addKeyStore$22 = false;
                    String $i$a$-checkNotNull-TLSConfigBuilderKt$addKeyStore$22 = "Fail to get the certificate chain for this alias: " + certAlias;
                    throw new IllegalStateException($i$a$-checkNotNull-TLSConfigBuilderKt$addKeyStore$22.toString());
                }
                Certificate[] $this$all$iv = chain;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int element$iv$iv = 0; element$iv$iv < n; ++element$iv$iv) {
                    Certificate element$iv;
                    Certificate it = element$iv = $this$all$iv[element$iv$iv];
                    boolean bl2 = false;
                    if (it instanceof X509Certificate) continue;
                    bl = false;
                    break block10;
                }
                bl = allX509 = true;
            }
            if (!allX509) {
                boolean bl = false;
                String string = "Fail to add key store " + store + ". Only X509 certificate format supported.";
                throw new IllegalStateException(string.toString());
            }
            for (X509KeyManager manager : managers) {
                PrivateKey key;
                void $this$mapTo$iv$iv;
                if (manager.getPrivateKey(certAlias) == null) continue;
                Certificate[] $this$map$iv = chain;
                boolean $i$f$map = false;
                Certificate[] bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var24_34 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((X509Certificate)it);
                }
                List map = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = map;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
                Intrinsics.checkNotNull((Object)x509CertificateArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                TLSConfigBuilderKt.addCertificateChain($this$addKeyStore, x509CertificateArray, key);
                continue block1;
            }
            throw new NoPrivateKeyException(certAlias, store);
        }
    }

    public static /* synthetic */ void addKeyStoreNullablePassword$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStoreNullablePassword(tLSConfigBuilder, keyStore, cArray, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final X509TrustManager findTrustManager() {
        void $this$filterIsInstanceTo$iv$iv;
        TrustManager[] manager;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNull((Object)trustManagerFactory);
        TrustManagerFactory factory = trustManagerFactory;
        factory.init((KeyStore)null);
        TrustManager[] trustManagerArray = factory.getTrustManagers();
        Intrinsics.checkNotNull((Object)trustManagerArray);
        TrustManager[] $this$filterIsInstance$iv = manager = trustManagerArray;
        boolean $i$f$filterIsInstance = false;
        TrustManager[] trustManagerArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509TrustManager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (X509TrustManager)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

