/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.URLDecodeException;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a8\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002\u001a0\u0010\u001d\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002\u001a,\u0010\u001e\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u000e2\f\b\u0002\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c\u001a6\u0010\u001f\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\f\b\u0002\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c\u001a\n\u0010 \u001a\u00020\u0013*\u00020\u0013\u001a\u0014\u0010!\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u0019\u001a\f\u0010#\u001a\u00020\u0013*\u00020\u0013H\u0000\u001a\n\u0010$\u001a\u00020\u0013*\u00020\u0013\u001a\u0014\u0010$\u001a\u00020\u0013*\u00020\u00132\u0006\u0010%\u001a\u00020\u0019H\u0000\u001a\n\u0010&\u001a\u00020\u0013*\u00020\u0013\u001a,\u0010'\u001a\u00020\u0013*\u00020\u00132\b\b\u0002\u0010(\u001a\u00020\u00192\b\b\u0002\u0010\"\u001a\u00020\u00192\f\b\u0002\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c\u001a \u0010)\u001a\u00020**\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020*0-H\u0002\u001a\f\u0010.\u001a\u00020\u0013*\u00020\bH\u0002\u001a\u001a\u0010.\u001a\u00020\u0013*\u00020\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"ATTRIBUTE_CHARACTERS", "", "", "getATTRIBUTE_CHARACTERS", "()Ljava/util/Set;", "HEX_ALPHABET", "SPECIAL_SYMBOLS", "", "", "URL_ALPHABET", "URL_ALPHABET_CHARS", "URL_PROTOCOL_PART", "VALID_PATH_PART", "charToHexDigit", "", "c2", "hexDigitToChar", "digit", "decodeImpl", "", "", "start", "end", "prefixEnd", "plusIsSpace", "", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "decodeScan", "decodeURLPart", "decodeURLQueryComponent", "encodeOAuth", "encodeURLParameter", "spaceToPlus", "encodeURLParameterValue", "encodeURLPath", "encodeSlash", "encodeURLPathPart", "encodeURLQueryComponent", "encodeFull", "forEach", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "block", "Lkotlin/Function1;", "percentEncode", "allowedSet", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCodecs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Codecs.kt\nio/ktor/http/CodecsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Strings.kt\nio/ktor/utils/io/core/StringsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 StringsJVM.kt\nio/ktor/utils/io/core/StringsJVMKt\n+ 6 Input.kt\nio/ktor/utils/io/core/InputKt\n+ 7 Buffer.kt\nio/ktor/utils/io/core/BufferKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n1099#2,3:297\n8#3,3:300\n13586#4,2:303\n11#5:305\n823#6,6:306\n829#6,13:313\n354#7:312\n1549#8:326\n1620#8,3:327\n1549#8:330\n1620#8,3:331\n1549#8:334\n1620#8,3:335\n*S KotlinDebug\n*F\n+ 1 Codecs.kt\nio/ktor/http/CodecsKt\n*L\n130#1:297,3\n133#1:300,3\n141#1:303,2\n250#1:305\n289#1:306,6\n289#1:313,13\n290#1:312\n9#1:326\n9#1:327,3\n20#1:330\n20#1:331,3\n42#1:334\n42#1:335,3\n*E\n"})
public final class CodecsKt {
    @NotNull
    private static final Set<Byte> URL_ALPHABET;
    @NotNull
    private static final Set<Character> URL_ALPHABET_CHARS;
    @NotNull
    private static final Set<Character> HEX_ALPHABET;
    @NotNull
    private static final List<Byte> URL_PROTOCOL_PART;
    @NotNull
    private static final Set<Character> VALID_PATH_PART;
    @NotNull
    private static final Set<Character> ATTRIBUTE_CHARACTERS;
    @NotNull
    private static final List<Byte> SPECIAL_SYMBOLS;

    @NotNull
    public static final Set<Character> getATTRIBUTE_CHARACTERS() {
        return ATTRIBUTE_CHARACTERS;
    }

    @NotNull
    public static final String encodeURLQueryComponent(@NotNull String $this$encodeURLQueryComponent, boolean encodeFull, boolean spaceToPlus, @NotNull Charset charset) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLQueryComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        StringBuilder $this$encodeURLQueryComponent_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
        ByteReadPacket content = EncodingKt.encode$default((CharsetEncoder)charsetEncoder, (CharSequence)$this$encodeURLQueryComponent, (int)0, (int)0, (int)6, null);
        CodecsKt.forEach(content, (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(spaceToPlus, $this$encodeURLQueryComponent_u24lambda_u243, encodeFull){
            final /* synthetic */ boolean $spaceToPlus;
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ boolean $encodeFull;
            {
                this.$spaceToPlus = $spaceToPlus;
                this.$this_buildString = $receiver;
                this.$encodeFull = $encodeFull;
                super(1);
            }

            public final void invoke(byte it) {
                if (it == 32) {
                    if (this.$spaceToPlus) {
                        this.$this_buildString.append('+');
                    } else {
                        this.$this_buildString.append("%20");
                    }
                } else if (CodecsKt.access$getURL_ALPHABET$p().contains(it) || !this.$encodeFull && CodecsKt.access$getURL_PROTOCOL_PART$p().contains(it)) {
                    this.$this_buildString.append((char)it);
                } else {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }
        }));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String encodeURLQueryComponent$default(String string, boolean bl, boolean bl2, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.encodeURLQueryComponent(string, bl, bl2, charset);
    }

    @NotNull
    public static final String encodeURLPath(@NotNull String $this$encodeURLPath) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLPath, (String)"<this>");
        return CodecsKt.encodeURLPath($this$encodeURLPath, false);
    }

    @NotNull
    public static final String encodeURLPathPart(@NotNull String $this$encodeURLPathPart) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLPathPart, (String)"<this>");
        return CodecsKt.encodeURLPath($this$encodeURLPathPart, true);
    }

    @NotNull
    public static final String encodeURLPath(@NotNull String $this$encodeURLPath, boolean encodeSlash) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLPath, (String)"<this>");
        StringBuilder $this$encodeURLPath_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        int index = 0;
        while (index < $this$encodeURLPath.length()) {
            char current = $this$encodeURLPath.charAt(index);
            if (!encodeSlash && current == '/' || URL_ALPHABET_CHARS.contains(Character.valueOf(current)) || VALID_PATH_PART.contains(Character.valueOf(current))) {
                $this$encodeURLPath_u24lambda_u244.append(current);
                ++index;
                continue;
            }
            if (current == '%' && index + 2 < $this$encodeURLPath.length() && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index + 1))) && HEX_ALPHABET.contains(Character.valueOf($this$encodeURLPath.charAt(index + 2)))) {
                $this$encodeURLPath_u24lambda_u244.append(current);
                $this$encodeURLPath_u24lambda_u244.append($this$encodeURLPath.charAt(index + 1));
                $this$encodeURLPath_u24lambda_u244.append($this$encodeURLPath.charAt(index + 2));
                index += 3;
                continue;
            }
            int symbolSize = CharsKt.isSurrogate((char)current) ? 2 : 1;
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            CodecsKt.forEach(EncodingKt.encode((CharsetEncoder)charsetEncoder, (CharSequence)$this$encodeURLPath, (int)index, (int)(index + symbolSize)), (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>($this$encodeURLPath_u24lambda_u244){
                final /* synthetic */ StringBuilder $this_buildString;
                {
                    this.$this_buildString = $receiver;
                    super(1);
                }

                public final void invoke(byte it) {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }));
            index += symbolSize;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String encodeOAuth(@NotNull String $this$encodeOAuth) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeOAuth, (String)"<this>");
        return CodecsKt.encodeURLParameter$default($this$encodeOAuth, false, 1, null);
    }

    @NotNull
    public static final String encodeURLParameter(@NotNull String $this$encodeURLParameter, boolean spaceToPlus) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLParameter, (String)"<this>");
        StringBuilder $this$encodeURLParameter_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharsetEncoder charsetEncoder = Charsets.UTF_8.newEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"UTF_8.newEncoder()");
        ByteReadPacket content = EncodingKt.encode$default((CharsetEncoder)charsetEncoder, (CharSequence)$this$encodeURLParameter, (int)0, (int)0, (int)6, null);
        CodecsKt.forEach(content, (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>($this$encodeURLParameter_u24lambda_u245, spaceToPlus){
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ boolean $spaceToPlus;
            {
                this.$this_buildString = $receiver;
                this.$spaceToPlus = $spaceToPlus;
                super(1);
            }

            public final void invoke(byte it) {
                if (CodecsKt.access$getURL_ALPHABET$p().contains(it) || CodecsKt.access$getSPECIAL_SYMBOLS$p().contains(it)) {
                    this.$this_buildString.append((char)it);
                } else if (this.$spaceToPlus && it == 32) {
                    this.$this_buildString.append('+');
                } else {
                    this.$this_buildString.append(CodecsKt.access$percentEncode(it));
                }
            }
        }));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String encodeURLParameter$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CodecsKt.encodeURLParameter(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String percentEncode(@NotNull String $this$percentEncode, @NotNull Set<Character> allowedSet) {
        byte[] byArray;
        void $this$toByteArray$iv;
        Intrinsics.checkNotNullParameter((Object)$this$percentEncode, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowedSet, (String)"allowedSet");
        CharSequence $this$count$iv = $this$percentEncode;
        boolean $i$f$count22 = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(!allowedSet.contains(Character.valueOf(it)))) continue;
            ++count$iv;
        }
        int encodedCount = count$iv;
        if (encodedCount == 0) {
            return $this$percentEncode;
        }
        String $i$f$count22 = $this$percentEncode;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray$iv), (int)0, (int)$this$toByteArray$iv.length());
        }
        byte[] content = byArray;
        int rawCount = $this$percentEncode.length() - encodedCount;
        int resultSize = rawCount + (content.length - rawCount) * 3;
        char[] result = new char[resultSize];
        int writeIndex = 0;
        byte[] $this$forEach$iv = content;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            char c = (char)it;
            if (allowedSet.contains(Character.valueOf(c))) {
                int n2 = writeIndex;
                writeIndex = n2 + 1;
                result[n2] = c;
                continue;
            }
            int code = it & 0xFF;
            int n3 = writeIndex;
            writeIndex = n3 + 1;
            result[n3] = 37;
            n3 = writeIndex;
            writeIndex = n3 + 1;
            result[n3] = CodecsKt.hexDigitToChar(code >> 4);
            n3 = writeIndex;
            writeIndex = n3 + 1;
            result[n3] = CodecsKt.hexDigitToChar(code & 0xF);
        }
        return StringsKt.concatToString((char[])result);
    }

    @NotNull
    public static final String encodeURLParameterValue(@NotNull String $this$encodeURLParameterValue) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeURLParameterValue, (String)"<this>");
        return CodecsKt.encodeURLParameter($this$encodeURLParameterValue, true);
    }

    @NotNull
    public static final String decodeURLQueryComponent(@NotNull String $this$decodeURLQueryComponent, int start, int end, boolean plusIsSpace, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeURLQueryComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CodecsKt.decodeScan($this$decodeURLQueryComponent, start, end, plusIsSpace, charset);
    }

    public static /* synthetic */ String decodeURLQueryComponent$default(String string, int n, int n2, boolean bl, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLQueryComponent(string, n, n2, bl, charset);
    }

    @NotNull
    public static final String decodeURLPart(@NotNull String $this$decodeURLPart, int start, int end, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeURLPart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return CodecsKt.decodeScan($this$decodeURLPart, start, end, false, charset);
    }

    public static /* synthetic */ String decodeURLPart$default(String string, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        return CodecsKt.decodeURLPart(string, n, n2, charset);
    }

    private static final String decodeScan(String $this$decodeScan, int start, int end, boolean plusIsSpace, Charset charset) {
        String string;
        for (int index = start; index < end; ++index) {
            char ch = $this$decodeScan.charAt(index);
            if (ch != '%' && (!plusIsSpace || ch != '+')) continue;
            return CodecsKt.decodeImpl($this$decodeScan, start, end, index, plusIsSpace, charset);
        }
        if (start == 0 && end == $this$decodeScan.length()) {
            string = $this$decodeScan.toString();
        } else {
            String string2 = $this$decodeScan.substring(start, end);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    private static final String decodeImpl(CharSequence $this$decodeImpl, int start, int end, int prefixEnd, boolean plusIsSpace, Charset charset) {
        int length = end - start;
        int sbSize = length > 255 ? length / 3 : length;
        StringBuilder sb = new StringBuilder(sbSize);
        if (prefixEnd > start) {
            sb.append($this$decodeImpl, start, prefixEnd);
        }
        int index = prefixEnd;
        byte[] bytes = null;
        while (index < end) {
            char c = $this$decodeImpl.charAt(index);
            if (plusIsSpace && c == '+') {
                sb.append(' ');
                ++index;
                continue;
            }
            if (c == '%') {
                if (bytes == null) {
                    bytes = new byte[(end - index) / 3];
                }
                int count = 0;
                while (index < end && $this$decodeImpl.charAt(index) == '%') {
                    if (index + 2 >= end) {
                        CharSequence charSequence = $this$decodeImpl;
                        int n = charSequence.length();
                        throw new URLDecodeException("Incomplete trailing HEX escape: " + ((Object)charSequence.subSequence(index, n)).toString() + ", in " + $this$decodeImpl + " at " + index);
                    }
                    int digit1 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index + 1));
                    int digit2 = CodecsKt.charToHexDigit($this$decodeImpl.charAt(index + 2));
                    if (digit1 == -1 || digit2 == -1) {
                        throw new URLDecodeException("Wrong HEX escape: %" + $this$decodeImpl.charAt(index + 1) + $this$decodeImpl.charAt(index + 2) + ", in " + $this$decodeImpl + ", at " + index);
                    }
                    bytes[count++] = (byte)(digit1 * 16 + digit2);
                    index += 3;
                }
                int offset$iv = 0;
                boolean $i$f$String = false;
                sb.append(new String(bytes, offset$iv, count, charset));
                continue;
            }
            sb.append(c);
            ++index;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final String percentEncode(byte $this$percentEncode) {
        int code = $this$percentEncode & 0xFF;
        char[] array = new char[]{'%', CodecsKt.hexDigitToChar(code >> 4), CodecsKt.hexDigitToChar(code & 0xF)};
        return StringsKt.concatToString((char[])array);
    }

    private static final int charToHexDigit(char c2) {
        int n;
        block1: {
            char c;
            block0: {
                c = c2;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = c2 - 48;
                break block1;
            }
            n = ('A' <= c ? c < 'G' : false) ? c2 - 65 + 10 : (('a' <= c ? c < 'g' : false) ? c2 - 97 + 10 : -1);
        }
        return n;
    }

    private static final char hexDigitToChar(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? (char)(48 + digit) : (char)((char)(65 + digit) - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void forEach(ByteReadPacket $this$forEach, Function1<? super Byte, Unit> block) {
        Input $this$takeWhile$iv = (Input)$this$forEach;
        boolean $i$f$takeWhile = false;
        boolean release$iv = true;
        ChunkBuffer chunkBuffer = UnsafeKt.prepareReadFirstHead((Input)$this$takeWhile$iv, (int)1);
        if (chunkBuffer != null) {
            ChunkBuffer current$iv = chunkBuffer;
            try {
                while (true) {
                    ChunkBuffer next$iv;
                    Buffer buffer = (Buffer)current$iv;
                    boolean bl = false;
                    while (true) {
                        Buffer $this$canRead$iv = buffer;
                        boolean $i$f$canRead = false;
                        if (!($this$canRead$iv.getWritePosition() > $this$canRead$iv.getReadPosition())) break;
                        block.invoke((Object)buffer.readByte());
                    }
                    if (!true) {
                        break;
                    }
                    release$iv = false;
                    if (UnsafeKt.prepareReadNextHead((Input)$this$takeWhile$iv, (ChunkBuffer)current$iv) == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                }
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead((Input)$this$takeWhile$iv, (ChunkBuffer)current$iv);
                }
            }
        }
    }

    public static final /* synthetic */ Set access$getURL_ALPHABET$p() {
        return URL_ALPHABET;
    }

    public static final /* synthetic */ List access$getURL_PROTOCOL_PART$p() {
        return URL_PROTOCOL_PART;
    }

    public static final /* synthetic */ String access$percentEncode(byte $receiver) {
        return CodecsKt.percentEncode($receiver);
    }

    public static final /* synthetic */ List access$getSPECIAL_SYMBOLS$p() {
        return SPECIAL_SYMBOLS;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        char it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = (Object[])CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            char c = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_ALPHABET = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        URL_ALPHABET_CHARS = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9'))));
        HEX_ALPHABET = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'f')), (Iterable)((Iterable)new CharRange('A', 'F'))), (Iterable)((Iterable)new CharRange('0', '9'))));
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~'), Character.valueOf('+')};
        $this$map$iv = SetsKt.setOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_PROTOCOL_PART = (List)destination$iv$iv;
        $this$map$iv = new Character[]{Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        VALID_PATH_PART = SetsKt.setOf((Object[])$this$map$iv);
        $this$map$iv = new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~')};
        ATTRIBUTE_CHARACTERS = SetsKt.plus(URL_ALPHABET_CHARS, (Iterable)SetsKt.setOf((Object[])$this$map$iv));
        $this$map$iv = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        SPECIAL_SYMBOLS = (List)var3_3;
    }
}

