/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/content/URIFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "url", "Ljava/net/URL;", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/net/URL;Lio/ktor/http/ContentType;)V", "uri", "Ljava/net/URI;", "contentLength", "", "(Ljava/net/URI;Lio/ktor/http/ContentType;Ljava/lang/Long;)V", "getContentLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "getUri", "()Ljava/net/URI;", "readFrom", "Lio/ktor/utils/io/ByteReadChannel;", "ktor-http"})
public final class URIFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final URI uri;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final Long contentLength;

    public URIFileContent(@NotNull URI uri, @NotNull ContentType contentType2, @Nullable Long contentLength) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.uri = uri;
        this.contentType = contentType2;
        this.contentLength = contentLength;
    }

    public /* synthetic */ URIFileContent(URI uRI, ContentType contentType2, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRI.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        if ((n & 4) != 0) {
            l = null;
        }
        this(uRI, contentType2, l);
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public Long getContentLength() {
        return this.contentLength;
    }

    public URIFileContent(@NotNull URL url, @NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        URI uRI = url.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"url.toURI()");
        this(uRI, contentType2, null, 4, null);
    }

    public /* synthetic */ URIFileContent(URL uRL, ContentType contentType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            contentType2 = FileContentTypeKt.defaultForFilePath(ContentType.Companion, string);
        }
        this(uRL, contentType2);
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        InputStream inputStream = this.uri.toURL().openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"uri.toURL().openStream()");
        return ReadingKt.toByteReadChannel$default((InputStream)inputStream, null, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool(), (int)1, null);
    }
}

