/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"parseRangesSpecifier", "Lio/ktor/http/RangesSpecifier;", "rangeSpec", "", "mergeRangesKeepOrder", "", "Lkotlin/ranges/LongRange;", "toLongRanges", "Lio/ktor/http/ContentRange;", "contentLength", "", "ktor-http"})
public final class RangesKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangesSpecifier parseRangesSpecifier(@NotNull String rangeSpec) {
        Intrinsics.checkNotNullParameter((Object)rangeSpec, (String)"rangeSpec");
        try {
            void $this$mapTo$iv$iv;
            void $this$chomp$iv;
            String string = rangeSpec;
            String separator$iv = "=";
            boolean $i$f$chomp = false;
            int idx$iv22 = StringsKt.indexOf$default((CharSequence)((CharSequence)$this$chomp$iv), (String)separator$iv, (int)0, (boolean)false, (int)6, null);
            if (idx$iv22 == -1) {
                boolean bl = false;
                return null;
            }
            String string2 = $this$chomp$iv.substring(0, idx$iv22);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string3 = $this$chomp$iv.substring(idx$iv22 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            Pair pair = TuplesKt.to((Object)string2, (Object)string3);
            String unit = (String)pair.component1();
            String allRangesString = (String)pair.component2();
            char[] idx$iv22 = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)allRangesString, (char[])idx$iv22, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ContentRange contentRange;
                void it;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) {
                    contentRange = new ContentRange.Suffix(Long.parseLong(StringsKt.removePrefix((String)it, (CharSequence)"-")));
                } else {
                    Pair pair2;
                    void $this$chomp$iv2;
                    void var14_18 = it;
                    String separator$iv2 = "-";
                    boolean $i$f$chomp2 = false;
                    int idx$iv = StringsKt.indexOf$default((CharSequence)((CharSequence)$this$chomp$iv2), (String)separator$iv2, (int)0, (boolean)false, (int)6, null);
                    if (idx$iv == -1) {
                        boolean bl2 = false;
                        pair2 = TuplesKt.to((Object)"", (Object)"");
                    } else {
                        String string5 = $this$chomp$iv2.substring(0, idx$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String string6 = $this$chomp$iv2.substring(idx$iv + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                        pair2 = TuplesKt.to((Object)string5, (Object)string6);
                    }
                    Pair pair3 = pair2;
                    String from = (String)pair3.component1();
                    String to = (String)pair3.component2();
                    contentRange = ((CharSequence)to).length() > 0 ? (ContentRange)new ContentRange.Bounded(Long.parseLong(from), Long.parseLong(to)) : (ContentRange)new ContentRange.TailFrom(Long.parseLong(from));
                }
                collection.add(contentRange);
            }
            List allRanges = (List)destination$iv$iv;
            if (allRanges.isEmpty() || ((CharSequence)unit).length() == 0) {
                return null;
            }
            RangesSpecifier spec = new RangesSpecifier(unit, (List<? extends ContentRange>)allRanges);
            return RangesSpecifier.isValid$default(spec, null, 1, null) ? spec : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> toLongRanges(@NotNull List<? extends ContentRange> $this$toLongRanges, long contentLength) {
        void $this$filterNotTo$iv$iv;
        LongRange it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toLongRanges, (String)"<this>");
        Iterable $this$map$iv = $this$toLongRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LongRange longRange;
            ContentRange contentRange = (ContentRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LongRange longRange2 = it;
            if (longRange2 instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)it).getFrom(), kotlin.ranges.RangesKt.coerceAtMost((long)((ContentRange.Bounded)it).getTo(), (long)(contentLength - 1L)));
            } else if (longRange2 instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until((long)((ContentRange.TailFrom)it).getFrom(), (long)contentLength);
            } else if (longRange2 instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until((long)kotlin.ranges.RangesKt.coerceAtLeast((long)(contentLength - ((ContentRange.Suffix)it).getLastCount()), (long)0L), (long)contentLength);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(longRange);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (LongRange)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> mergeRangesKeepOrder(@NotNull List<LongRange> $this$mergeRangesKeepOrder) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeRangesKeepOrder, (String)"<this>");
        Iterable $this$sortedBy$iv = $this$mergeRangesKeepOrder;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LongRange it = (LongRange)a;
                boolean bl = false;
                Comparable comparable = it.getStart();
                it = (LongRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getStart());
            }
        });
        ArrayList<Object> initial$iv = new ArrayList<Object>($this$mergeRangesKeepOrder.size());
        boolean bl = false;
        ArrayList<Object> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void range;
            LongRange longRange = (LongRange)element$iv;
            ArrayList<Object> acc = accumulator$iv;
            boolean bl2 = false;
            if (acc.isEmpty()) {
                acc.add(range);
            } else if (((LongRange)CollectionsKt.last((List)acc)).getEndInclusive() < range.getStart() - 1L) {
                acc.add(range);
            } else {
                LongRange last = (LongRange)CollectionsKt.last((List)acc);
                acc.set(CollectionsKt.getLastIndex((List)acc), new LongRange(last.getStart().longValue(), Math.max(last.getEndInclusive(), range.getEndInclusive())));
            }
            accumulator$iv = acc;
        }
        ArrayList<Object> sortedMerged = accumulator$iv;
        Object[] result = new LongRange[$this$mergeRangesKeepOrder.size()];
        block1: for (LongRange longRange : sortedMerged) {
            int n = $this$mergeRangesKeepOrder.size();
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)longRange, (String)"range");
                if (!io.ktor.util.RangesKt.contains((LongRange)longRange, (LongRange)$this$mergeRangesKeepOrder.get(i))) continue;
                result[i] = longRange;
                continue block1;
            }
        }
        return ArraysKt.filterNotNull((Object[])result);
    }
}

