/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0007H\u0002\u001a,\u0010\u000f\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a$\u0010\u0011\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0012\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\u0013\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0016"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "parseFile", "slashCount", "parseFragment", "parseMailto", "parseQuery", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"$this$takeFrom");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw (Throwable)new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        String string;
        int it;
        int n;
        int n2;
        int n3;
        int startIndex;
        int it22;
        block22: {
            int n4;
            int n5;
            block21: {
                Intrinsics.checkNotNullParameter((Object)$this$takeFromUnsafe, (String)"$this$takeFromUnsafe");
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                int n6 = 0;
                n5 = $this$indexOfFirst$iv.length();
                while (n6 < n5) {
                    void index$iv;
                    it22 = $this$indexOfFirst$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)it22)) {
                        n4 = index$iv;
                        break block21;
                    }
                    ++index$iv;
                }
                n4 = -1;
            }
            startIndex = n4;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n5 = $this$indexOfLast$iv.length();
            --n5;
            it22 = 0;
            while (n5 >= 0) {
                void index$iv;
                char it3 = $this$indexOfLast$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it3)) {
                    n3 = index$iv;
                    break block22;
                }
                --index$iv;
            }
            n3 = -1;
        }
        int endIndex = n3 + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String index$iv = urlString;
            it22 = startIndex + schemeLength;
            n2 = 0;
            String string2 = index$iv.substring(startIndex, it22);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scheme = string2;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            boolean index$iv = slashCount == 0;
            it22 = 0;
            n2 = 0;
            n2 = 0;
            n = 0;
            if (!index$iv) {
                boolean bl = false;
                String string3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                String string4;
                Integer it22 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                n2 = 0;
                n = 0;
                it = ((Number)it22).intValue();
                boolean bl = false;
                Integer n7 = it > 0 ? it22 : null;
                int n8 = delimiter = n7 != null ? n7 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    string4 = urlString;
                    n = 0;
                    String string5 = string4.substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(string5, 0, 0, null, 7, null));
                    string4 = urlString;
                    n = passwordIndex + 1;
                    it = 0;
                    String string6 = string4.substring(n, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setPassword(CodecsKt.decodeURLPart$default(string6, 0, 0, null, 7, null));
                } else {
                    string4 = urlString;
                    n = 0;
                    String string7 = string4.substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setUser(CodecsKt.decodeURLPart$default(string7, 0, 0, null, 7, null));
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPath(urlString.charAt(endIndex - 1) == '/' ? "/" : "");
            return $this$takeFromUnsafe;
        }
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$this$takeFromUnsafe.getEncodedPath(), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIndex != $this$takeFromUnsafe.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String passwordIndex = $this$takeFromUnsafe.getEncodedPath();
                    n2 = 0;
                    n = lastSlashIndex + 1;
                    it = 0;
                    String string8 = passwordIndex;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n2, n);
                    string = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = "/";
                }
            } else {
                string = $this$takeFromUnsafe.getEncodedPath();
            }
        } else {
            string = "";
        }
        $this$takeFromUnsafe.setEncodedPath(string);
        Integer passwordIndex = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        n2 = 0;
        n = 0;
        it = ((Number)passwordIndex).intValue();
        boolean bl = false;
        Integer n9 = it > 0 ? passwordIndex : null;
        int pathEnd = n9 != null ? n9 : endIndex;
        String string10 = urlString;
        n = 0;
        String string11 = string10.substring(startIndex, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rawPath = string11;
        URLBuilder uRLBuilder = $this$takeFromUnsafe;
        uRLBuilder.setEncodedPath(uRLBuilder.getEncodedPath() + CodecsKt.encodeURLPath(rawPath));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        switch (slashCount) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    $this$parseFile.setHost(string3);
                    return;
                }
                String string = urlString;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setHost(string5);
                string = urlString;
                bl = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(string7);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                StringBuilder stringBuilder = new StringBuilder().append("/");
                String string = urlString;
                boolean bl = false;
                String string8 = string;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseFile.setEncodedPath(stringBuilder.append(string9).toString());
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Invalid file url: " + urlString);
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw (Throwable)new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string3, 0, 0, null, 7, null));
        string = urlString;
        n = delimiter + 1;
        boolean bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setHost(string5);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        boolean bl = false;
        int n2 = 0;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n3 = it > 0 ? n : null;
        int fragmentStart = n3 != null ? n3 : endIndex;
        String string = urlString;
        n2 = startIndex + 1;
        boolean bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n2, fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Parameters rawParameters = QueryKt.parseQueryString$default(string3, 0, 0, 6, null);
        rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($this$parseQuery){
            final /* synthetic */ URLBuilder $this_parseQuery;

            public final void invoke(@NotNull String key, @NotNull List<String> values) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.$this_parseQuery.getParameters().appendAll(key, values);
            }
            {
                this.$this_parseQuery = uRLBuilder;
                super(2);
            }
        });
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString;
            int n = startIndex + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$parseFragment.setFragment(string3);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        Object object = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int n = 0;
        boolean bl = false;
        int it = ((Number)object).intValue();
        boolean bl2 = false;
        Object object2 = it > 0 ? object : null;
        int colonIndex = object2 != null ? (Integer)object2 : endIndex;
        object = urlString;
        n = 0;
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            object = urlString;
            n = colonIndex + 1;
            bl = false;
            Object object4 = object;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object4).substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = string2;
            n = 0;
            $this$fillHost.setPort(Integer.parseInt((String)object));
        } else {
            $this$fillHost.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        char c = firstChar;
        if ('a' > c || 'z' < c) {
            c = firstChar;
            if ('A' > c || 'Z' < c) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c2;
            char c3 = urlString.charAt(current);
            if (c3 == ':') {
                if (incorrectSchemePosition != -1) {
                    throw (Throwable)new IllegalArgumentException("Illegal character in scheme at position " + incorrectSchemePosition);
                }
                return current - startIndex;
            }
            if (c3 == '/' || c3 == '?' || c3 == '#') {
                return -1;
            }
            if (incorrectSchemePosition == -1 && ('a' > (c2 = c3) || 'z' < c2)) {
                c2 = c3;
                if ('A' > c2 || 'Z' < c2) {
                    c2 = c3;
                    if ('0' > c2 || '9' < c2) {
                        if (c3 != '.' && c3 != '+' && c3 != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        int n2 = endIndex;
        while (n < n2) {
            void index;
            switch ($this$indexOfColonInHostPort.charAt((int)index)) {
                case '[': {
                    skip = true;
                    break;
                }
                case ']': {
                    skip = false;
                    break;
                }
                case ':': {
                    if (skip) break;
                    return (int)index;
                }
            }
            ++index;
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = $this$isLetter;
        boolean bl = false;
        char c2 = c;
        boolean bl2 = false;
        char c3 = Character.toLowerCase(c2);
        return 'a' <= c3 && 'z' >= c3;
    }
}

