/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006*\u00020\u0007\u001a\u001f\u0010\u0004\u001a\u0004\u0018\u00010\b*\u00020\u00072\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0003\u00a2\u0006\u0002\u0010\f\u001a\u0011\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\n\u001a\u00020\b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0003\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0007\u001a\u0012\u0010\u0010\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0007\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0003\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0007\u001a\u0012\u0010\u0017\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0016\u001a\u0012\u0010\u0019\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000f\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u0003\u001a\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u0016H\u0000\u001a\u0012\u0010\u001d\u001a\u00020\b*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0016\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0003\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0001*\u00020\u0007\u00a8\u0006 "}, d2={"cacheControl", "", "Lio/ktor/http/HeaderValue;", "Lio/ktor/http/HttpMessage;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Lio/ktor/http/HttpMessageBuilder;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "contentLength", "", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "length", "", "contentType", "Lio/ktor/http/ContentType;", "type", "cookies", "Lio/ktor/http/Cookie;", "etag", "", "ifNoneMatch", "value", "maxAge", "seconds", "setCookie", "splitSetCookieHeader", "userAgent", "content", "vary", "ktor-http"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $this$contentType, @NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"$this$contentType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        $this$contentType.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type.toString());
    }

    @Deprecated(message="Content-Length is controlled by underlying engine. Don't specify it explicitly.", level=DeprecationLevel.ERROR)
    public static final void contentLength(@NotNull HttpMessageBuilder $this$contentLength, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"$this$contentLength");
        $this$contentLength.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length));
    }

    @Deprecated(message="Use content with particular content type and charset instead", level=DeprecationLevel.ERROR)
    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $this$charset, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"$this$charset");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        if (contentType2 != null) {
            ContentType contentType3 = contentType2;
            boolean bl = false;
            boolean bl2 = false;
            ContentType it = contentType3;
            boolean bl3 = false;
            HttpMessagePropertiesKt.contentType($this$charset, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $this$maxAge, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$maxAge, (String)"$this$maxAge");
        $this$maxAge.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age=" + seconds);
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $this$ifNoneMatch, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$ifNoneMatch, (String)"$this$ifNoneMatch");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$ifNoneMatch.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $this$userAgent, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"$this$userAgent");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        $this$userAgent.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"$this$contentType");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"$this$charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $this$etag) {
        Intrinsics.checkNotNullParameter((Object)$this$etag, (String)"$this$etag");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$vary, (String)"$this$vary");
        Object object = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var10_10 = it;
                boolean bl2 = false;
                void v1 = var10_10;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $this$contentLength) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"$this$contentLength");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            l = Long.parseLong(string2);
        } else {
            l = null;
        }
        return l;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $this$contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"$this$contentType");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $this$charset) {
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"$this$charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $this$etag) {
        Intrinsics.checkNotNullParameter((Object)$this$etag, (String)"$this$etag");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$vary, (String)"$this$vary");
        Object object = $this$vary.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var10_10 = it;
                boolean bl2 = false;
                void v1 = var10_10;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $this$contentLength) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"$this$contentLength");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            l = Long.parseLong(string2);
        } else {
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $this$setCookie) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$setCookie, (String)"$this$setCookie");
        List list2 = $this$setCookie.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = HttpMessagePropertiesKt.splitSetCookieHeader(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Cookie cookie = CookieKt.parseServerSetCookieHeader(it);
                collection.add(cookie);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $this$cookies) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$cookies, (String)"$this$cookies");
        List list2 = $this$cookies.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<HeaderValue> cacheControl(@NotNull HttpMessage $this$cacheControl) {
        List<HeaderValue> list;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"$this$cacheControl");
                list = $this$cacheControl.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
                if (list == null) break block2;
                String string = list;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                list = HttpHeaderValueParserKt.parseHeaderValue(it);
                if (list != null) break block3;
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<String> splitSetCookieHeader(@NotNull String $this$splitSetCookieHeader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$splitSetCookieHeader, (String)"$this$splitSetCookieHeader");
        int comma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)0, (boolean)false, (int)6, null);
        if (comma == -1) {
            return CollectionsKt.listOf((Object)$this$splitSetCookieHeader);
        }
        boolean bl = false;
        List result = new ArrayList();
        int current = 0;
        int equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)'=', (int)comma, (boolean)false, (int)4, null);
        int semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)';', (int)comma, (boolean)false, (int)4, null);
        while (current < $this$splitSetCookieHeader.length() && comma > 0) {
            boolean bl2;
            String string;
            if (equals < comma) {
                equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)'=', (int)comma, (boolean)false, (int)4, null);
            }
            int nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)(comma + 1), (boolean)false, (int)4, null);
            while (nextComma >= 0 && nextComma < equals) {
                comma = nextComma;
                nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)',', (int)(nextComma + 1), (boolean)false, (int)4, null);
            }
            if (semicolon < comma) {
                semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, (char)';', (int)comma, (boolean)false, (int)4, null);
            }
            if (equals < 0) {
                object = result;
                string = $this$splitSetCookieHeader;
                bl2 = false;
                String string2 = string.substring(current);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                string = string2;
                bl2 = false;
                object.add(string);
                return result;
            }
            if (semicolon == -1 || semicolon > equals) {
                object = result;
                string = $this$splitSetCookieHeader;
                bl2 = false;
                String string3 = string.substring(current, comma);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string3;
                bl2 = false;
                object.add(string);
                current = comma + 1;
            }
            comma = nextComma;
        }
        if (current < $this$splitSetCookieHeader.length()) {
            Collection collection = result;
            object = $this$splitSetCookieHeader;
            boolean bl3 = false;
            String string = ((String)object).substring(current);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            object = string;
            bl3 = false;
            collection.add(object);
        }
        return result;
    }
}

