/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0007H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0011"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $receiver, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($receiver, urlString);
        }
        catch (Throwable cause) {
            throw (Throwable)new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $receiver, @NotNull String urlString) {
        String string;
        String string2;
        URLBuilder uRLBuilder;
        int n;
        int it4;
        int n2;
        int it22;
        int startIndex;
        block21: {
            int n3;
            char it3;
            int n4;
            block20: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
                CharSequence $receiver$iv = urlString;
                int n5 = 0;
                n4 = $receiver$iv.length();
                while (n5 < n4) {
                    void index$iv;
                    it3 = $receiver$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)it3)) {
                        n3 = index$iv;
                        break block20;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            startIndex = n3;
            CharSequence $receiver$iv = urlString;
            n4 = $receiver$iv.length();
            --n4;
            it3 = '\u0000';
            while (n4 >= 0) {
                void index$iv;
                it22 = $receiver$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it22)) {
                    n2 = index$iv;
                    break block21;
                }
                --index$iv;
            }
            n2 = -1;
        }
        int endIndex = n2 + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String it3 = urlString;
            it22 = startIndex + schemeLength;
            String string3 = it3.substring(startIndex, it22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scheme = string3;
            $receiver.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                String it4;
                Integer it22 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                it4 = ((Number)it22).intValue();
                n = 0;
                Integer n6 = it4 > 0 ? it22 : null;
                int n7 = delimiter = n6 != null ? n6 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    it4 = urlString;
                    uRLBuilder = $receiver;
                    String string4 = it4.substring(startIndex, passwordIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string4;
                    uRLBuilder.setUser(string2);
                    it4 = urlString;
                    n = passwordIndex + 1;
                    uRLBuilder = $receiver;
                    String string5 = it4.substring(n, delimiter);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string5;
                    uRLBuilder.setPassword(string2);
                } else {
                    it4 = urlString;
                    uRLBuilder = $receiver;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it4.substring(startIndex, delimiter), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    uRLBuilder.setUser(string2);
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($receiver, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $receiver.setEncodedPath("/");
            return $receiver;
        }
        URLBuilder uRLBuilder2 = $receiver;
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$receiver.getEncodedPath(), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIndex != $receiver.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String passwordIndex = $receiver.getEncodedPath();
                    it4 = 0;
                    n = lastSlashIndex + 1;
                    uRLBuilder = uRLBuilder2;
                    String string6 = passwordIndex;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(it4, n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string7;
                    uRLBuilder2 = uRLBuilder;
                    string = string2;
                } else {
                    string = "/";
                }
            } else {
                string = $receiver.getEncodedPath();
            }
        } else {
            string = "";
        }
        uRLBuilder2.setEncodedPath(string);
        Integer passwordIndex = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        it4 = ((Number)passwordIndex).intValue();
        boolean bl2 = false;
        Integer n8 = it4 > 0 ? passwordIndex : null;
        int pathEnd = n8 != null ? n8 : endIndex;
        String it23 = urlString;
        String string8 = it23.substring(startIndex, pathEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rawPath = string8;
        URLBuilder uRLBuilder3 = $receiver;
        uRLBuilder3.setEncodedPath(uRLBuilder3.getEncodedPath() + CodecsKt.encodeURLPath(rawPath));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            if (startIndex + 1 == endIndex) {
                $receiver.setTrailingQuery(true);
                return $receiver;
            }
            Integer bl2 = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
            int it5 = ((Number)bl2).intValue();
            boolean bl3 = false;
            Integer n9 = it5 > 0 ? bl2 : null;
            int fragmentStart = n9 != null ? n9 : endIndex;
            String string9 = urlString;
            int n10 = startIndex + 1;
            String string10 = string9.substring(n10, fragmentStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Parameters rawParameters = QueryKt.parseQueryString$default(string10, 0, 0, 6, null);
            rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($receiver){
                final /* synthetic */ URLBuilder $this_takeFromUnsafe;

                public final void invoke(@NotNull String key, @NotNull List<String> values) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull(values, (String)"values");
                    this.$this_takeFromUnsafe.getParameters().appendAll(key, values);
                }
                {
                    this.$this_takeFromUnsafe = uRLBuilder;
                    super(2);
                }
            });
            startIndex = fragmentStart;
        }
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string11 = urlString;
            int n11 = startIndex + 1;
            uRLBuilder = $receiver;
            String string12 = string11.substring(n11, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string12;
            uRLBuilder.setFragment(string2);
        }
        return $receiver;
    }

    private static final void fillHost(@NotNull URLBuilder $receiver, String urlString, int startIndex, int endIndex) {
        Object object = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object object2 = it > 0 ? object : null;
        int colonIndex = object2 != null ? (Integer)object2 : endIndex;
        object = urlString;
        URLBuilder uRLBuilder = $receiver;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).substring(startIndex, colonIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string2 = string;
        uRLBuilder.setHost(string2);
        if (colonIndex + 1 < endIndex) {
            object = urlString;
            int n = colonIndex + 1;
            uRLBuilder = $receiver;
            Object object4 = object;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object4).substring(n, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string3;
            object = string2;
            int n2 = Integer.parseInt((String)object);
            uRLBuilder.setPort(n2);
        } else {
            $receiver.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        for (int current = startIndex; current < endIndex; ++current) {
            char c = urlString.charAt(current);
            if (c == ':') {
                return current;
            }
            if (URLParserKt.isLetter(c)) continue;
            return -1;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfColonInHostPort(@NotNull String $receiver, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        int n2 = endIndex;
        while (n < n2) {
            void index;
            switch ($receiver.charAt((int)index)) {
                case '[': {
                    skip = true;
                    break;
                }
                case ']': {
                    skip = false;
                    break;
                }
                case ':': {
                    if (skip) break;
                    return (int)index;
                }
            }
            ++index;
        }
        return -1;
    }

    private static final boolean isLetter(char $receiver) {
        char c = $receiver;
        char c2 = 'a';
        char c3 = 'z';
        char c4 = Character.toLowerCase(c);
        char c5 = c4;
        return c2 <= c5 && c3 >= c5;
    }
}

