/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.numerics;

import io.kotlintest.DslKt;
import io.kotlintest.Matcher;
import io.kotlintest.MatcherResult;
import io.kotlintest.matchers.IntMatchersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0017\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\r\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u000e\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0010\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0007*\u00020\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0007*\u00020\u0002\u001a\u0015\u0010\u0017\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0019\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u001a\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u001b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\u001c\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\u001e"}, d2={"beEven", "Lio/kotlintest/Matcher;", "", "beOdd", "negative", "positive", "shouldBeBetween", "", "a", "b", "shouldBeEven", "shouldBeExactly", "x", "shouldBeGreaterThan", "shouldBeGreaterThanOrEqual", "shouldBeLessThan", "shouldBeLessThanOrEqual", "shouldBeNegative", "shouldBeOdd", "shouldBePositive", "shouldBeZero", "shouldNotBeBetween", "shouldNotBeEven", "shouldNotBeExactly", "shouldNotBeGreaterThan", "shouldNotBeGreaterThanOrEqual", "shouldNotBeLessThan", "shouldNotBeLessThanOrEqual", "shouldNotBeOdd", "shouldNotBeZero", "kotlintest-assertions"})
public final class IntKt {
    public static final void shouldBePositive(int $this$shouldBePositive) {
        DslKt.shouldBe($this$shouldBePositive, IntKt.positive());
    }

    @NotNull
    public static final Matcher<Integer> positive() {
        return new Matcher<Integer>(){

            @NotNull
            public MatcherResult test(int value) {
                return MatcherResult.Companion.invoke(value > 0, value + " should be > 0", value + " should not be > 0");
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, Integer> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap(this, f);
            }

            @NotNull
            public Matcher<Integer> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Integer> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Integer> and(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Integer> or(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeNegative(int $this$shouldBeNegative) {
        DslKt.shouldBe($this$shouldBeNegative, IntKt.negative());
    }

    @NotNull
    public static final Matcher<Integer> negative() {
        return new Matcher<Integer>(){

            @NotNull
            public MatcherResult test(int value) {
                return MatcherResult.Companion.invoke(value < 0, value + " should be < 0", value + " should not be < 0");
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, Integer> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap(this, f);
            }

            @NotNull
            public Matcher<Integer> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Integer> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Integer> and(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Integer> or(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeEven(int $this$shouldBeEven) {
        DslKt.should(Integer.valueOf($this$shouldBeEven), IntKt.beEven());
    }

    public static final void shouldNotBeEven(int $this$shouldNotBeEven) {
        DslKt.shouldNot($this$shouldNotBeEven, IntKt.beEven());
    }

    @NotNull
    public static final Matcher<Integer> beEven() {
        return new Matcher<Integer>(){

            @NotNull
            public MatcherResult test(int value) {
                return MatcherResult.Companion.invoke(value % 2 == 0, value + " should be even", value + " should be odd");
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, Integer> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap(this, f);
            }

            @NotNull
            public Matcher<Integer> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Integer> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Integer> and(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Integer> or(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeOdd(int $this$shouldBeOdd) {
        DslKt.should(Integer.valueOf($this$shouldBeOdd), IntKt.beOdd());
    }

    public static final void shouldNotBeOdd(int $this$shouldNotBeOdd) {
        DslKt.shouldNot($this$shouldNotBeOdd, IntKt.beOdd());
    }

    @NotNull
    public static final Matcher<Integer> beOdd() {
        return new Matcher<Integer>(){

            @NotNull
            public MatcherResult test(int value) {
                return MatcherResult.Companion.invoke(value % 2 == 1, value + " should be odd", value + " should be even");
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, Integer> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap(this, f);
            }

            @NotNull
            public Matcher<Integer> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Integer> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<Integer> and(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<Integer> or(@NotNull Matcher<Integer> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }

    public static final void shouldBeBetween(int $this$shouldBeBetween, int a, int b) {
        DslKt.shouldBe($this$shouldBeBetween, IntMatchersKt.between(a, b));
    }

    public static final void shouldNotBeBetween(int $this$shouldNotBeBetween, int a, int b) {
        DslKt.shouldNot($this$shouldNotBeBetween, IntMatchersKt.between(a, b));
    }

    public static final void shouldBeLessThan(int $this$shouldBeLessThan, int x) {
        DslKt.shouldBe($this$shouldBeLessThan, IntMatchersKt.lt(x));
    }

    public static final void shouldNotBeLessThan(int $this$shouldNotBeLessThan, int x) {
        DslKt.shouldNotBe($this$shouldNotBeLessThan, IntMatchersKt.lt(x));
    }

    public static final void shouldBeLessThanOrEqual(int $this$shouldBeLessThanOrEqual, int x) {
        DslKt.shouldBe($this$shouldBeLessThanOrEqual, IntMatchersKt.lte(x));
    }

    public static final void shouldNotBeLessThanOrEqual(int $this$shouldNotBeLessThanOrEqual, int x) {
        DslKt.shouldNotBe($this$shouldNotBeLessThanOrEqual, IntMatchersKt.lte(x));
    }

    public static final void shouldBeGreaterThan(int $this$shouldBeGreaterThan, int x) {
        DslKt.shouldBe($this$shouldBeGreaterThan, IntMatchersKt.gt(x));
    }

    public static final void shouldNotBeGreaterThan(int $this$shouldNotBeGreaterThan, int x) {
        DslKt.shouldNotBe($this$shouldNotBeGreaterThan, IntMatchersKt.gt(x));
    }

    public static final void shouldBeGreaterThanOrEqual(int $this$shouldBeGreaterThanOrEqual, int x) {
        DslKt.shouldBe($this$shouldBeGreaterThanOrEqual, IntMatchersKt.gte(x));
    }

    public static final void shouldNotBeGreaterThanOrEqual(int $this$shouldNotBeGreaterThanOrEqual, int x) {
        DslKt.shouldNotBe($this$shouldNotBeGreaterThanOrEqual, IntMatchersKt.gte(x));
    }

    public static final void shouldBeExactly(int $this$shouldBeExactly, int x) {
        DslKt.shouldBe($this$shouldBeExactly, IntMatchersKt.exactly(x));
    }

    public static final void shouldNotBeExactly(int $this$shouldNotBeExactly, int x) {
        DslKt.shouldNotBe($this$shouldNotBeExactly, IntMatchersKt.exactly(x));
    }

    public static final void shouldBeZero(int $this$shouldBeZero) {
        IntKt.shouldBeExactly($this$shouldBeZero, 0);
    }

    public static final void shouldNotBeZero(int $this$shouldNotBeZero) {
        IntKt.shouldNotBeExactly($this$shouldNotBeZero, 0);
    }
}

