/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.testtools;

import io.javalin.Javalin;
import io.javalin.json.JsonMapper;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0007J\"\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0007J.\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0007J.\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0007J.\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0007J\u001c\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020!J\u000e\u0010\"\u001a\u00020#*\u0004\u0018\u00010\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lio/javalin/testtools/HttpClient;", "", "app", "Lio/javalin/Javalin;", "okHttp", "Lokhttp3/OkHttpClient;", "(Lio/javalin/Javalin;Lokhttp3/OkHttpClient;)V", "getApp", "()Lio/javalin/Javalin;", "getOkHttp", "()Lokhttp3/OkHttpClient;", "origin", "", "getOrigin", "()Ljava/lang/String;", "setOrigin", "(Ljava/lang/String;)V", "combine", "Lokhttp3/Request$Builder;", "userBuilder", "Ljava/util/function/Consumer;", "utilBuilder", "delete", "Lokhttp3/Response;", "path", "json", "req", "get", "patch", "post", "put", "request", "builder", "Lokhttp3/Request;", "toRequestBody", "Lokhttp3/RequestBody;", "Companion", "javalin-testtools"})
@SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\nio/javalin/testtools/HttpClient\n+ 2 JsonMapper.kt\nio/javalin/json/JsonMapperKt\n*L\n1#1,65:1\n71#2:66\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\nio/javalin/testtools/HttpClient\n*L\n50#1:66\n*E\n"})
public final class HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Javalin app;
    @NotNull
    private final OkHttpClient okHttp;
    @NotNull
    private String origin;
    @NotNull
    private static final MediaType JSON_TYPE = MediaType.Companion.get("application/json");

    public HttpClient(@NotNull Javalin app, @NotNull OkHttpClient okHttp) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)okHttp, (String)"okHttp");
        this.app = app;
        this.okHttp = okHttp;
        this.origin = "http://127.0.0.1:" + this.app.port();
    }

    @NotNull
    public final Javalin getApp() {
        return this.app;
    }

    @NotNull
    public final OkHttpClient getOkHttp() {
        return this.okHttp;
    }

    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.origin = string;
    }

    @NotNull
    public final Response request(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.okHttp.newCall(request).execute();
    }

    @NotNull
    public final Response request(@NotNull String path, @NotNull Request.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.request(builder.url(this.origin + path).build());
    }

    @NotNull
    public final Response request(@NotNull String path, @NotNull Consumer<Request.Builder> userBuilder) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(userBuilder, (String)"userBuilder");
        Request.Builder finalBuilder = new Request.Builder();
        userBuilder.accept(finalBuilder);
        return this.request(finalBuilder.url(this.origin + path).build());
    }

    @JvmOverloads
    @NotNull
    public final Response get(@NotNull String path, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, HttpClient::get$lambda$0));
    }

    public static /* synthetic */ Response get$default(HttpClient httpClient, String string, Consumer consumer, int n, Object object) {
        if ((n & 2) != 0) {
            consumer = null;
        }
        return httpClient.get(string, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.post$lambda$1(this, json, arg_0)));
    }

    public static /* synthetic */ Response post$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.post(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.put$lambda$2(this, json, arg_0)));
    }

    public static /* synthetic */ Response put$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.put(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.patch$lambda$3(this, json, arg_0)));
    }

    public static /* synthetic */ Response patch$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.patch(string, object, consumer);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path, @Nullable Object json, @Nullable Consumer<Request.Builder> req) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.request(path, this.combine(req, arg_0 -> HttpClient.delete$lambda$4(this, json, arg_0)));
    }

    public static /* synthetic */ Response delete$default(HttpClient httpClient, String string, Object object, Consumer consumer, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            consumer = null;
        }
        return httpClient.delete(string, object, consumer);
    }

    private final RequestBody toRequestBody(Object $this$toRequestBody) {
        RequestBody requestBody;
        if ($this$toRequestBody == null) {
            requestBody = RequestBody.Companion.create(new byte[0], null, 0, 0);
        } else {
            JsonMapper $this$toJsonString$iv = (JsonMapper)this.app.unsafeConfig().pvt.jsonMapper.getValue();
            boolean $i$f$toJsonString = false;
            requestBody = RequestBody.Companion.create($this$toJsonString$iv.toJsonString($this$toRequestBody, TypesJVMKt.getJavaType((KType)Reflection.typeOf(Object.class))), JSON_TYPE);
        }
        return requestBody;
    }

    private final Request.Builder combine(Consumer<Request.Builder> userBuilder, Consumer<Request.Builder> utilBuilder) {
        Request.Builder finalBuilder = new Request.Builder();
        Consumer<Request.Builder> consumer = userBuilder;
        if (consumer != null) {
            consumer.accept(finalBuilder);
        }
        utilBuilder.accept(finalBuilder);
        return finalBuilder;
    }

    @JvmOverloads
    @NotNull
    public final Response get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.get$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.post$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response post(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.post$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.put$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response put(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.put$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.patch$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response patch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.patch$default(this, path, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path, @Nullable Object json) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.delete$default(this, path, json, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Response delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return HttpClient.delete$default(this, path, null, null, 6, null);
    }

    private static final void get$lambda$0(Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.get();
    }

    private static final void post$lambda$1(HttpClient this$0, Object $json, Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.post(this$0.toRequestBody($json));
    }

    private static final void put$lambda$2(HttpClient this$0, Object $json, Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.put(this$0.toRequestBody($json));
    }

    private static final void patch$lambda$3(HttpClient this$0, Object $json, Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.patch(this$0.toRequestBody($json));
    }

    private static final void delete$lambda$4(HttpClient this$0, Object $json, Request.Builder it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.delete(this$0.toRequestBody($json));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/javalin/testtools/HttpClient$Companion;", "", "()V", "JSON_TYPE", "Lokhttp3/MediaType;", "javalin-testtools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

