/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.instrumentation.stats.Stats;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.trace.Tracing;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.InternalNotifyOnServerBuild;
import io.grpc.ServerBuilder;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import io.grpc.internal.CensusStatsModule;
import io.grpc.internal.CensusTracingModule;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalHandlerRegistry;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImpl;
import io.grpc.internal.SharedResourcePool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final HandlerRegistry EMPTY_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    private final ArrayList<ServerTransportFilter> transportFilters = new ArrayList();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    private final List<ServerStreamTracer.Factory> streamTracerFactories = new ArrayList<ServerStreamTracer.Factory>();
    @Nullable
    private HandlerRegistry fallbackRegistry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add((ServerTransportFilter)Preconditions.checkNotNull((Object)filter, (Object)"filter"));
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.streamTracerFactories.add((ServerStreamTracer.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @VisibleForTesting
    protected T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        StatsContextFactory statsFactory;
        ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList<ServerStreamTracer.Factory>();
        StatsContextFactory statsContextFactory = statsFactory = this.statsFactory != null ? this.statsFactory : Stats.getStatsContextFactory();
        if (statsFactory != null) {
            CensusStatsModule censusStats = new CensusStatsModule(statsFactory, GrpcUtil.STOPWATCH_SUPPLIER, true);
            tracerFactories.add(censusStats.getServerTracerFactory());
        }
        CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getBinaryPropagationHandler());
        tracerFactories.add(censusTracing.getServerTracerFactory());
        tracerFactories.addAll(this.streamTracerFactories);
        InternalServer transportServer = this.buildTransportServer(Collections.unmodifiableList(tracerFactories));
        ServerImpl server = new ServerImpl(this.getExecutorPool(), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), this.registryBuilder.build(), (HandlerRegistry)MoreObjects.firstNonNull((Object)this.fallbackRegistry, (Object)EMPTY_FALLBACK_REGISTRY), transportServer, Context.ROOT, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.transportFilters);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    private ObjectPool<? extends Executor> getExecutorPool() {
        final Executor savedExecutor = this.executor;
        if (savedExecutor == null) {
            return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return new ObjectPool<Executor>(){

            @Override
            public Executor getObject() {
                return savedExecutor;
            }

            @Override
            public Executor returnObject(Object object) {
                return null;
            }
        };
    }

    protected abstract InternalServer buildTransportServer(List<ServerStreamTracer.Factory> var1);

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

