/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.provider.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import io.github.xanthic.cache.core.delegate.GenericMapCacheDelegate;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class CaffeineDelegate<K, V>
extends GenericMapCacheDelegate<K, V> {
    private final Cache<K, V> cache;

    public CaffeineDelegate(Cache<K, V> cache) {
        super((Map)cache.asMap());
        this.cache = cache;
    }

    public V get(@NotNull K key) {
        return (V)this.cache.getIfPresent(key);
    }

    public V computeIfAbsent(@NotNull K key, @NotNull Function<K, V> computeFunc) {
        return (V)this.cache.get(key, computeFunc);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public long size() {
        this.cache.cleanUp();
        return this.cache.estimatedSize();
    }

    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    public Cache<K, V> getCache() {
        return this.cache;
    }

    public String toString() {
        return "CaffeineDelegate(cache=" + this.getCache() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineDelegate)) {
            return false;
        }
        CaffeineDelegate other = (CaffeineDelegate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Cache<K, V> this$cache = this.getCache();
        Cache<K, V> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaffeineDelegate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cache<K, V> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }
}

