/*
 *    Copyright 2022 Whilein
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package w.util.ci;

import org.jetbrains.annotations.NotNull;

/**
 * Не чувствительная к регистру строка
 *
 * @author whilein
 */
public interface CiString {

    int length();

    boolean equals(byte coder, byte[] value);

    boolean equals(Object object);

    boolean equals(CiString another);

    boolean equals(String another);

    /**
     * Получить {@code hashCode} строки в нижнем регистре, согласно спецификации {@link String}
     *
     * @return {@code hashCode} строки в нижнем регистре
     */
    int hashCode();

    /**
     * Получить оригинальную строку (с изначальным регистром)
     *
     * @return Оригинальная строка
     */
    @NotNull String toString();

}
