/*
 * Decompiled with CFR 0.152.
 */
package w.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import w.impl.Impl;
import w.impl.ImplModel;
import w.impl.ImplPriority;

public final class ImplProcessor
extends AbstractProcessor {
    private final Map<String, List<ImplModel>> models = new HashMap<String, List<ImplModel>>();

    private static String getClassName(TypeElement type) {
        Element enclosedIn = type.getEnclosingElement();
        if (enclosedIn instanceof TypeElement) {
            return ImplProcessor.getClassName((TypeElement)enclosedIn) + "$" + type.getSimpleName();
        }
        return type.getQualifiedName().toString();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Impl.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private String getClassName(Class<?> cls) {
        try {
            return cls.getName();
        }
        catch (MirroredTypeException e) {
            return this.getClassName(e.getTypeMirror());
        }
    }

    private String getClassName(TypeMirror type) {
        return ImplProcessor.getClassName(this.processingEnv.getElementUtils().getTypeElement(type.toString()));
    }

    private void addModel(String apiName, String implName, String factory, ImplPriority priority) {
        this.models.computeIfAbsent(apiName, x -> new ArrayList()).add(new ImplModel(implName, factory, priority));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Impl.class)) {
            TypeElement type = (TypeElement)element;
            String name = ImplProcessor.getClassName(type);
            Impl annotation = element.getAnnotation(Impl.class);
            ImplPriority priority = annotation.priority();
            try {
                void var11_20;
                Class<?>[] classArray = annotation.types();
                int n = classArray.length;
                boolean bl = false;
                while (var11_20 < n) {
                    Class<?> apiType = classArray[var11_20];
                    this.addModel(this.getClassName(apiType), name, annotation.factory(), priority);
                    ++var11_20;
                }
            }
            catch (MirroredTypesException e) {
                for (TypeMirror typeMirror : e.getTypeMirrors()) {
                    this.addModel(this.getClassName(typeMirror), name, annotation.factory(), priority);
                }
            }
        }
        if (roundEnv.processingOver()) {
            for (Map.Entry entry : this.models.entrySet()) {
                String apiName = (String)entry.getKey();
                List modelList = (List)entry.getValue();
                try {
                    FileObject object = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/impl/" + apiName, new Element[0]);
                    try (Writer writer = object.openWriter();){
                        for (ImplModel model : modelList) {
                            writer.append(model.getImplType());
                            writer.append(':');
                            writer.append(model.getFactoryMethod());
                            writer.append(':');
                            writer.append(model.getPriority().name());
                            writer.append('\n');
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

