/*
 * Decompiled with CFR 0.152.
 */
package w.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import w.impl.ImplModel;
import w.impl.ImplPriority;

public final class ImplLoader {
    private static final Map<Class<?>, ImplModel> IMPLEMENTATIONS = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImplModel getModel(Class<?> cls) {
        Map<Class<?>, ImplModel> map = IMPLEMENTATIONS;
        synchronized (map) {
            return IMPLEMENTATIONS.computeIfAbsent(cls, ImplLoader::readModel);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ImplModel readModel(Class<?> cls) {
        try (InputStream is = cls.getClassLoader().getResourceAsStream("META-INF/impl/" + cls.getName());){
            ImplModel implModel;
            if (is == null) {
                ImplModel implModel2 = null;
                return implModel2;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                implModel = br.lines().map(line -> {
                    String[] spec = line.split(":");
                    return new ImplModel(spec[0], spec[1], ImplPriority.valueOf(spec[2]));
                }).min(Comparator.naturalOrder()).orElse(null);
            }
            return implModel;
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T create(@NotNull Class<T> type, Object ... parameters) {
        return ImplLoader.find(type, parameters).orElseThrow(() -> new IllegalStateException("No implementation found for " + type.getName()));
    }

    @NotNull
    public static <T> Optional<T> find(@NotNull Class<T> type, Object ... parameters) {
        ImplModel impl = ImplLoader.getModel(type);
        if (impl == null) {
            return Optional.empty();
        }
        String factory = impl.getFactoryMethod();
        String implTypeName = impl.getImplType();
        try {
            Class<?> implType = Class.forName(implTypeName, true, type.getClassLoader());
            if (factory.equals("<init>")) {
                for (Constructor<?> constructor : implType.getDeclaredConstructors()) {
                    if (constructor.getParameterCount() != parameters.length) continue;
                    constructor.setAccessible(true);
                    return Optional.of(constructor.newInstance(parameters));
                }
            } else {
                for (Method method : implType.getDeclaredMethods()) {
                    if (!method.getName().equals(factory) || method.getParameterCount() != parameters.length) continue;
                    method.setAccessible(true);
                    return Optional.of(method.invoke(null, parameters));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load implementation " + type.getName(), e);
        }
        return Optional.empty();
    }

    private ImplLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

