/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.Objects;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.RenderedBone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface BonePredicate
extends Predicate<RenderedBone> {
    public static final BonePredicate TRUE = BonePredicate.of(State.TRUE, b -> true);
    public static final BonePredicate FALSE = BonePredicate.of(State.FALSE, b -> false);

    @NotNull
    public State applyAtChildren();

    @NotNull
    public static BonePredicate of(@NotNull Predicate<RenderedBone> predicate) {
        return BonePredicate.of(State.FALSE, predicate);
    }

    @NotNull
    public static BonePredicate of(final @NotNull State applyAtChildren, final @NotNull Predicate<RenderedBone> predicate) {
        Objects.requireNonNull(predicate, "predicate cannot be null.");
        return new BonePredicate(){

            @Override
            @NotNull
            public State applyAtChildren() {
                return applyAtChildren;
            }

            @Override
            public boolean test(RenderedBone renderedBone) {
                return predicate.test(renderedBone);
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    default public BonePredicate children(boolean parentSuccess) {
        BonePredicate bonePredicate;
        if (parentSuccess) {
            switch (this.applyAtChildren().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    bonePredicate = TRUE;
                    break;
                }
                case 1: {
                    bonePredicate = FALSE;
                    break;
                }
                case 2: {
                    bonePredicate = this;
                    break;
                }
            }
        } else {
            bonePredicate = this;
        }
        return bonePredicate;
    }

    public static enum State {
        TRUE,
        FALSE,
        NOT_SET;

    }
}

