/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.event.CloseTrackerEvent;
import kr.toxicity.model.api.event.ModelDespawnAtPlayerEvent;
import kr.toxicity.model.api.event.ModelSpawnAtPlayerEvent;
import kr.toxicity.model.api.manager.ConfigManager;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.ModelRotator;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tracker
implements AutoCloseable {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(256);
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));
    protected final RenderInstance instance;
    private final ScheduledFuture<?> task;
    private final RenderSource source;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean readyForForceUpdate = new AtomicBoolean();
    private final TrackerModifier modifier;
    private final Runnable updater;
    private PacketBundler bundler;
    private PacketBundler forceUpdateBundler;
    private long frame = 0L;
    private ModelRotator rotator = ModelRotator.EMPTY;
    private BiConsumer<Tracker, PacketBundler> consumer = (t, b) -> {};

    public Tracker(@NotNull RenderSource source, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        this.instance = instance;
        this.source = source;
        this.modifier = modifier;
        this.bundler = instance.createBundler();
        this.forceUpdateBundler = BetterModel.inst().nms().createBundler(instance.getDisplayAmount() + 10);
        ConfigManager config = BetterModel.inst().configManager();
        this.updater = () -> {
            instance.move(this.frame % 5L == 0L ? (this.isRunningSingleAnimation() && config.lockOnPlayAnimation() ? instance.getRotation() : this.rotation()) : null, this.bundler);
            this.consumer.accept(this, this.forceUpdateBundler);
            if (this.readyForForceUpdate.compareAndSet(true, false)) {
                instance.forceUpdate(this.forceUpdateBundler);
            }
            if (!this.forceUpdateBundler.isEmpty()) {
                instance.allPlayer().map(PlayerChannelHandler::player).forEach(this.forceUpdateBundler::send);
                this.forceUpdateBundler = BetterModel.inst().nms().createBundler(instance.getDisplayAmount() + 10);
            }
            if (!this.bundler.isEmpty()) {
                instance.viewedPlayer().forEach(this.bundler::send);
                this.bundler = instance.createBundler();
            }
        };
        this.task = EXECUTOR.scheduleAtFixedRate(() -> {
            if (this.playerCount() > 0 || this.isRunningSingleAnimation()) {
                this.updater.run();
            }
            ++this.frame;
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        this.tint(0xFFFFFF);
        if (modifier.sightTrace()) {
            instance.viewFilter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.tick((t, b) -> t.instance.getScriptProcessor().tick());
    }

    @NotNull
    public final ModelRotation rotation() {
        return (ModelRotation)this.rotator.get();
    }

    public final void rotation(@NotNull ModelRotator newRotator) {
        this.rotator = newRotator;
    }

    public void frame(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.consumer = this.consumer.andThen(consumer);
    }

    public void tick(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.schedule(5L, consumer);
    }

    public void tick(long tick, @NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.schedule(5L * tick, consumer);
    }

    public void schedule(long period, @NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        if (period <= 0L) {
            throw new RuntimeException("period cannot be <= 0");
        }
        this.frame((t, b) -> {
            if (this.frame % period == 0L) {
                consumer.accept((Tracker)t, (PacketBundler)b);
            }
        });
    }

    protected void update() {
        this.updater.run();
    }

    @NotNull
    public String name() {
        return this.instance.getParent().name();
    }

    public double height() {
        return this.instance.height();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            EventUtil.call(new CloseTrackerEvent(this));
            this.task.cancel(true);
            this.instance.despawn();
        }
    }

    public void despawn() {
        if (!this.isClosed()) {
            this.instance.despawn();
        }
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public void forceUpdate(boolean force) {
        this.readyForForceUpdate.set(force);
    }

    public boolean isRunningSingleAnimation() {
        RenderedBone.RunningAnimation runningAnimation = this.instance.runningAnimation();
        return runningAnimation != null && runningAnimation.type() == AnimationIterator.Type.PLAY_ONCE;
    }

    protected boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        if (this.isClosed()) {
            return false;
        }
        if (!EventUtil.call(new ModelSpawnAtPlayerEvent(player, this))) {
            return false;
        }
        this.instance.spawn(player, bundler);
        return true;
    }

    public boolean remove(@NotNull Player player) {
        if (this.isClosed()) {
            return false;
        }
        EventUtil.call(new ModelDespawnAtPlayerEvent(player, this));
        this.instance.remove(player);
        return true;
    }

    public int playerCount() {
        return this.instance.playerCount();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.instance.viewedPlayer();
    }

    public void tint(int rgb) {
        this.tint(BonePredicate.TRUE, rgb);
    }

    public void tint(@NotNull BonePredicate predicate, int rgb) {
        if (this.instance.tint(predicate, rgb)) {
            this.forceUpdate(true);
        }
    }

    @NotNull
    public abstract Location location();

    @NotNull
    public abstract UUID uuid();

    public boolean animate(@NotNull String animation) {
        return this.animate(animation, AnimationModifier.DEFAULT);
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier) {
        return this.animate(animation, modifier, () -> {});
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animate(e -> true, animation, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.instance.animate(filter, animation, modifier, removeTask);
    }

    public void stopAnimation(@NotNull String animation) {
        this.stopAnimation(e -> true, animation);
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation) {
        this.instance.stopAnimation(filter, animation);
    }

    public boolean replace(@NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.replace(t -> true, target, animation, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.instance.replace(filter, target, animation, modifier);
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.instance.togglePart(predicate, toggle);
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.instance.itemStack(predicate, itemStack);
    }

    public boolean profile(@NotNull BonePredicate predicate, @NotNull Player player) {
        return this.instance.profile(predicate, player);
    }

    public boolean profile(@NotNull BonePredicate predicate, @NotNull Player player, @NotNull PlayerTextures.SkinModel skinModel) {
        return this.instance.profile(predicate, player, skinModel);
    }

    public boolean profile(@NotNull BonePredicate predicate, @NotNull PlayerProfile profile) {
        return this.instance.profile(predicate, profile);
    }

    public boolean profile(@NotNull BonePredicate predicate, @NotNull PlayerProfile profile, @NotNull PlayerTextures.SkinModel skinModel) {
        return this.instance.profile(predicate, profile, skinModel);
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.instance.glow(predicate, glow, glowColor);
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.instance.enchant(predicate, enchant);
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.instance.brightness(predicate, block, sky);
    }

    public boolean updateItem(@NotNull BonePredicate predicate) {
        return this.instance.updateItem(predicate);
    }

    @Nullable
    public RenderedBone bone(@NotNull BoneName name) {
        return this.bone((RenderedBone b) -> b.getName().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull String name) {
        return this.bone((RenderedBone b) -> b.getName().name().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull Predicate<RenderedBone> predicate) {
        return this.instance.boneOf(predicate);
    }

    @NotNull
    public List<RenderedBone> bones() {
        return this.instance.bones();
    }

    @NotNull
    public List<ModelDisplay> displays() {
        return this.bones().stream().map(RenderedBone::getDisplay).filter(Objects::nonNull).toList();
    }

    @Generated
    public RenderInstance getInstance() {
        return this.instance;
    }

    @Generated
    public RenderSource getSource() {
        return this.source;
    }

    @Generated
    public ModelRotator getRotator() {
        return this.rotator;
    }
}

