/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.ItemUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements HitBoxSource {
    private static final Vector3f EMPTY_VECTOR = new Vector3f();
    private static final Quaternionf EMPTY_QUATERNION = new Quaternionf();
    @NotNull
    private final RendererGroup group;
    @Nullable
    private ModelDisplay display;
    private final BoneMovement defaultFrame;
    @NotNull
    private final RenderedBone root;
    @Nullable
    private final RenderedBone parent;
    @NotNull
    private final Map<BoneName, RenderedBone> children;
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private AnimationMovement keyFrame = null;
    private long delay = 0L;
    private boolean forceUpdateAnimation = true;
    private TransformedItemStack cachedItem;
    private TransformedItemStack itemStack;
    private final List<Consumer<AnimationMovement>> movementModifier = new ArrayList<Consumer<AnimationMovement>>();
    @Nullable
    private HitBox hitBox;
    private final boolean dummyBone;
    private BoneItemMapper itemMapper;
    private int tint;
    private TreeIterator currentIterator = null;
    private BoneMovement beforeTransform;
    private BoneMovement afterTransform;
    private BoneMovement relativeOffsetCache;
    private Supplier<Vector3f> defaultPosition = FunctionUtil.asSupplier(new Vector3f());
    private ModelRotation rotation = ModelRotation.EMPTY;
    private Supplier<Float> scale = FunctionUtil.asSupplier(Float.valueOf(1.0f));

    @ApiStatus.Internal
    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull BoneMovement movement, @NotNull TrackerModifier modifier, @NotNull Function<RenderedBone, Map<BoneName, RenderedBone>> childrenMapper) {
        this.group = group;
        this.parent = parent;
        this.itemMapper = group.getItemMapper();
        RenderedBone r = this;
        while (r.getParent() != null) {
            r = r.getParent();
        }
        this.root = r;
        boolean visible = this.itemMapper != BoneItemMapper.EMPTY || group.getParent().visibility();
        this.cachedItem = itemStack;
        this.itemStack = visible ? itemStack : itemStack.asAir();
        this.dummyBone = ItemUtil.isEmpty(itemStack);
        if (!this.dummyBone) {
            this.display = BetterModel.inst().nms().create(firstLocation);
            this.display.display(transform);
            this.display.viewRange(modifier.viewRange());
            this.display.item(this.itemStack.itemStack());
        }
        this.defaultFrame = movement;
        this.children = Collections.unmodifiableMap(childrenMapper.apply(this));
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        TreeIterator iterator = this.currentIterator;
        return iterator != null ? iterator.animation : null;
    }

    public boolean updateItem(@NotNull BonePredicate predicate, @NotNull RenderSource source) {
        return this.itemStack(predicate, (TransformedItemStack)this.itemMapper.apply(source, this.cachedItem));
    }

    public boolean createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        if (predicate.test(this)) {
            NamedBoundingBox h = this.group.getHitBox();
            if (h == null) {
                h = ModelBoundingBox.MIN.named(this.group.getName());
            }
            HitBoxListener l = listener;
            if (this.hitBox != null) {
                this.hitBox.removeHitBox();
                if (l == null) {
                    l = this.hitBox.listener();
                }
            }
            this.hitBox = BetterModel.inst().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
            return this.hitBox != null;
        }
        return false;
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        if (predicate.test(this)) {
            this.itemStack = this.itemStack.modify(i -> {
                if (ItemUtil.isEmpty(i)) {
                    return i;
                }
                ItemMeta meta = i.getItemMeta();
                if (enchant) {
                    meta.addEnchant(Enchantment.UNBREAKING, 0, true);
                } else {
                    meta.removeEnchant(Enchantment.UNBREAKING);
                }
                i.setItemMeta(meta);
                return i;
            });
            return this.applyItem();
        }
        return false;
    }

    public void moveDuration(int duration) {
        if (this.display != null) {
            this.display.moveDuration(duration);
        }
    }

    public void scale(@NotNull Supplier<Float> scale) {
        this.scale = scale;
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        if (predicate.test(this) && this.display != null) {
            this.display.glow(glow);
            this.display.glowColor(glowColor);
            return true;
        }
        return false;
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        if (predicate.test(this)) {
            this.itemStack = this.cachedItem = itemStack;
            return this.applyItem();
        }
        return false;
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        if (predicate.test(this) && this.display != null) {
            this.display.brightness(block, sky);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimationMovementModifier(@NotNull BonePredicate predicate, @NotNull Consumer<AnimationMovement> consumer) {
        if (predicate.test(this)) {
            List<Consumer<AnimationMovement>> list = this.movementModifier;
            synchronized (list) {
                this.movementModifier.add(consumer);
            }
            return true;
        }
        return false;
    }

    private boolean shouldUpdateAnimation() {
        boolean success = false;
        if (this.forceUpdateAnimation) {
            this.forceUpdateAnimation = false;
            success = true;
        }
        return success || this.delay <= 0L || this.delay % 5L == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator = this.reversedView.iterator();
            while (iterator.hasNext()) {
                TreeIterator next = iterator.next();
                if (!next.get().booleanValue()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    this.currentIterator = next;
                    return true;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0L;
                    return true;
                }
                if (this.delay <= 0L) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    return true;
                }
                return false;
            }
        }
        this.relativeOffsetCache = null;
        this.keyFrame = null;
        return true;
    }

    private boolean updateKeyframe(Iterator<TreeIterator> iterator, TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator.remove();
            return false;
        }
        this.relativeOffsetCache = null;
        this.keyFrame = next.next();
        return true;
    }

    public boolean move(@Nullable ModelRotation rotation, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (rotation != null) {
            this.rotation = rotation;
            if (d != null) {
                d.rotate(rotation, bundler);
            }
        }
        --this.delay;
        if (this.shouldUpdateAnimation() && this.updateAnimation()) {
            int f = this.frame();
            this.delay = f;
            this.beforeTransform = this.afterTransform;
            BoneMovement entityMovement = this.afterTransform = this.relativeOffset();
            if (d != null) {
                d.frame(RenderedBone.toInterpolationDuration(f));
                this.setup(entityMovement);
                d.sendTransformation(bundler);
                return true;
            }
        }
        return false;
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(bundler);
        }
    }

    private static int toInterpolationDuration(long delay) {
        return (int)Math.floor((float)delay / 5.0f) + 1;
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset) {
        return this.worldPosition(localOffset, EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset, @NotNull Vector3f globalOffset) {
        float progress = 1.0f - this.progress();
        BoneMovement after = this.afterTransform != null ? this.afterTransform : this.relativeOffset();
        BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
        return VectorUtil.linear(before.transform(), after.transform(), progress).add((Vector3fc)this.itemStack.offset()).add((Vector3fc)localOffset).mul((Vector3fc)VectorUtil.linear(before.scale(), after.scale(), progress)).rotate((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(VectorUtil.linear(before.rawRotation(), after.rawRotation(), progress)))).add((Vector3fc)globalOffset).add((Vector3fc)this.root.getGroup().getPosition()).mul(this.scale.get().floatValue()).rotateX(-this.rotation.radianX()).rotateY(-this.rotation.radianY());
    }

    private void setup(@NotNull BoneMovement boneMovement) {
        if (this.display != null) {
            Float mul = this.scale.get();
            this.display.transform(new Transformation(new Vector3f((Vector3fc)boneMovement.transform()).add((Vector3fc)this.root.group.getPosition()).add((Vector3fc)new Vector3f((Vector3fc)this.itemStack.offset()).rotate((Quaternionfc)boneMovement.rotation())).mul(mul.floatValue()).add((Vector3fc)this.defaultPosition.get()), boneMovement.rotation(), new Vector3f((Vector3fc)boneMovement.scale()).mul((Vector3fc)this.itemStack.scale()).mul(mul.floatValue()), EMPTY_QUATERNION));
        }
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.defaultPosition = () -> new Vector3f((Vector3fc)movement.get()).add((Vector3fc)this.itemStack.position());
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private BoneMovement defaultFrame() {
        AnimationMovement k = this.keyFrame != null ? this.keyFrame.copyNotNull() : new AnimationMovement(0.0f, new Vector3f(), new Vector3f(), new Vector3f());
        List<Consumer<AnimationMovement>> list = this.movementModifier;
        synchronized (list) {
            for (Consumer<AnimationMovement> consumer : this.movementModifier) {
                consumer.accept(k);
            }
        }
        return this.defaultFrame.plus(k);
    }

    private float progress() {
        int f = this.frame();
        return f == 0 ? 0.0f : (float)this.delay / (float)f;
    }

    @NotNull
    private BoneMovement relativeOffset() {
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        BoneMovement def = this.defaultFrame();
        if (this.parent != null) {
            BoneMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new BoneMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = def;
        return this.relativeOffsetCache;
    }

    public boolean tint(@NotNull BonePredicate predicate, int tint) {
        if (predicate.test(this)) {
            this.tint = tint;
            return this.applyItem();
        }
        return false;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(BetterModel.inst().nms().tint(this.itemStack.itemStack().clone(), this.tint));
            return true;
        }
        return false;
    }

    @NotNull
    public BoneName getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
    }

    public void spawn(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(bundler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimation(@NotNull AnimationPredicate filter, @NotNull String parent, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            TreeIterator iterator = get != null ? new TreeIterator(this, parent, get.iterator(type), modifier, removeTask) : new TreeIterator(this, parent, animator.emptyIterator(type), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator);
            }
            this.forceUpdateAnimation = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceAnimation(@NotNull AnimationPredicate filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(this, parent, get.iterator(type), v.modifier, v.removeTask) : new TreeIterator(this, parent, animator.emptyIterator(type), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(this, parent, get.iterator(type), modifier, () -> {}) : new TreeIterator(this, parent, animator.emptyIterator(type), modifier, () -> {}));
                }
            }
            this.forceUpdateAnimation = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.remove(parent);
            }
        }
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        if (predicate.test(this)) {
            this.itemStack = toggle ? this.cachedItem : this.cachedItem.asAir();
            return this.applyItem();
        }
        return false;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        return this.findNotNullByTree(b -> predicate.test((RenderedBone)b) ? b : null);
    }

    @Nullable
    public <T> T findNotNullByTree(@NotNull Function<RenderedBone, T> mapper) {
        T value = mapper.apply(this);
        if (value != null) {
            return value;
        }
        for (RenderedBone renderedBone : this.children.values()) {
            T childValue = renderedBone.findNotNullByTree(mapper);
            if (childValue == null) continue;
            return childValue;
        }
        return null;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> boneConsumer) {
        boneConsumer.accept(this);
        for (RenderedBone value : this.children.values()) {
            value.iterateTree(boneConsumer);
        }
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> bonePredicate) {
        boolean result = bonePredicate.test(this);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(bonePredicate)) continue;
            result = true;
        }
        return result;
    }

    public boolean iterateTree(@NotNull BonePredicate predicate, @NotNull BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        BonePredicate childPredicate = predicate.children(parentResult);
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    public boolean iterateAnimation(@NotNull AnimationPredicate predicate, @NotNull BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        AnimationPredicate childPredicate = predicate;
        if (parentResult) {
            childPredicate = childPredicate.children();
        }
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateAnimation(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox box = this.getGroup().getHitBox();
        if (box != null) {
            return this.worldPosition(box.centerPoint().mul(-1.0f, 1.0f, -1.0f));
        }
        return this.worldPosition();
    }

    @Override
    public float hitBoxScale() {
        return this.scale.get().floatValue();
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    @NotNull
    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @Nullable
    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @NotNull
    @Generated
    public RenderedBone getRoot() {
        return this.root;
    }

    @Nullable
    @Generated
    public RenderedBone getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public Map<BoneName, RenderedBone> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public boolean isDummyBone() {
        return this.dummyBone;
    }

    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @Generated
    public void setItemMapper(BoneItemMapper itemMapper) {
        this.itemMapper = itemMapper;
    }

    private class TreeIterator
    implements AnimationIterator,
    Supplier<Boolean>,
    Runnable {
        private final RunningAnimation animation;
        private final AnimationIterator iterator;
        private final AnimationModifier modifier;
        private final Runnable removeTask;
        private final AnimationMovement previous;
        private boolean started = false;
        private boolean ended = false;

        public TreeIterator(RenderedBone renderedBone, String name, AnimationIterator iterator, AnimationModifier modifier, Runnable removeTask) {
            this.animation = new RunningAnimation(name, iterator.type());
            this.iterator = iterator;
            this.modifier = modifier;
            this.removeTask = removeTask;
            this.previous = renderedBone.keyFrame != null ? renderedBone.keyFrame.time((float)modifier.end() / 20.0f) : new AnimationMovement((float)modifier.end() / 20.0f, null, null, null);
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public Boolean get() {
            return this.modifier.predicate().get();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return this.previous;
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            nxt = nxt.time(Math.max(nxt.time() / this.modifier.speedValue(), 0.01f));
            return nxt;
        }

        @Override
        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }

        @Override
        @NotNull
        public AnimationIterator.Type type() {
            return this.iterator.type();
        }
    }

    public record RunningAnimation(@NotNull String name, @NotNull AnimationIterator.Type type) {
    }
}

