/*
 * Decompiled with CFR 0.152.
 */
package imgui.app;

import imgui.ImGui;
import imgui.app.Color;
import imgui.app.Configuration;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import java.nio.IntBuffer;
import java.util.Objects;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryStack;

public abstract class Window {
    private final ImGuiImplGlfw imGuiGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 imGuiGl3 = new ImGuiImplGl3();
    private String glslVersion = null;
    protected long handle;
    protected final Color colorBg = new Color(0.5f, 0.5f, 0.5f, 1.0f);

    protected void init(Configuration config) {
        this.initWindow(config);
        this.initImGui(config);
        this.imGuiGlfw.init(this.handle, true);
        this.imGuiGl3.init(this.glslVersion);
    }

    protected void dispose() {
        this.imGuiGl3.dispose();
        this.imGuiGlfw.dispose();
        this.disposeImGui();
        this.disposeWindow();
    }

    protected void initWindow(Configuration config) {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        this.decideGlGlslVersions();
        GLFW.glfwWindowHint(131076, 0);
        this.handle = GLFW.glfwCreateWindow(config.getWidth(), config.getHeight(), config.getTitle(), 0L, 0L);
        if (this.handle == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.handle, pWidth, pHeight);
            GLFWVidMode vidmode = Objects.requireNonNull(GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor()));
            GLFW.glfwSetWindowPos(this.handle, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.handle);
        GL.createCapabilities();
        GLFW.glfwSwapInterval(1);
        if (config.isFullScreen()) {
            GLFW.glfwMaximizeWindow(this.handle);
        } else {
            GLFW.glfwShowWindow(this.handle);
        }
        this.clearBuffer();
        this.renderBuffer();
        GLFW.glfwSetWindowSizeCallback(this.handle, new GLFWWindowSizeCallback(){

            @Override
            public void invoke(long window, int width, int height) {
                Window.this.runFrame();
            }
        });
    }

    private void decideGlGlslVersions() {
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        if (isMac) {
            this.glslVersion = "#version 150";
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 2);
            GLFW.glfwWindowHint(139272, 204801);
            GLFW.glfwWindowHint(139270, 1);
        } else {
            this.glslVersion = "#version 130";
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 0);
        }
    }

    protected void initImGui(Configuration config) {
        ImGui.createContext();
    }

    protected void preProcess() {
    }

    protected void postProcess() {
    }

    protected void run() {
        while (!GLFW.glfwWindowShouldClose(this.handle)) {
            this.runFrame();
        }
    }

    protected void runFrame() {
        this.startFrame();
        this.preProcess();
        this.process();
        this.postProcess();
        this.endFrame();
    }

    public abstract void process();

    private void clearBuffer() {
        GL32.glClearColor(this.colorBg.getRed(), this.colorBg.getGreen(), this.colorBg.getBlue(), this.colorBg.getAlpha());
        GL32.glClear(16640);
    }

    protected void startFrame() {
        this.clearBuffer();
        this.imGuiGlfw.newFrame();
        ImGui.newFrame();
    }

    protected void endFrame() {
        ImGui.render();
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent(backupWindowPtr);
        }
        this.renderBuffer();
    }

    private void renderBuffer() {
        GLFW.glfwSwapBuffers(this.handle);
        GLFW.glfwPollEvents();
    }

    protected void disposeImGui() {
        ImGui.destroyContext();
    }

    protected void disposeWindow() {
        Callbacks.glfwFreeCallbacks(this.handle);
        GLFW.glfwDestroyWindow(this.handle);
        GLFW.glfwTerminate();
        Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
    }

    public final long getHandle() {
        return this.handle;
    }

    public final Color getColorBg() {
        return this.colorBg;
    }
}

